/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.wizard.GraphicConstants;
import com.freescale.s32ds.cross.wizard.ParameterControl;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page2.Messages;
import com.freescale.s32ds.cross.wizard.page2.Page2AbstractManager;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SectionFactory;
import org.eclipse.ui.forms.widgets.TreeNode;

public class Page2Tree
extends Page2AbstractManager {
    private static final Color BACKGROUND_COLOR = GraphicConstants.WHITE;
    private static final int DEFAULT_SECTION_STYLE = 16724;
    private static String PARAMETER_CORE_TAG = "core";
    private static String PARAMETER_PROJECT_NAME_TAG = "projectName";
    private Button multicore;
    private final List<Section> sections = new ArrayList<Section>();
    private final CProjectContext bootCoreContext;
    private TraverseListener traverseListener = evt -> {
        if (evt.detail == 4) {
            evt.doit = true;
        }
    };

    public void setTraverseListener(Section section) {
        Control[] controlArray = section.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof TreeNode) {
                control.addTraverseListener(this.traverseListener);
            }
            ++n2;
        }
    }

    public Page2Tree(ProcessorContext projectContext, S32DSMultiPageTwo wizardPage, Composite parent) {
        super(projectContext, wizardPage, parent);
        this.bootCoreContext = (CProjectContext)this.getProcessorContext().getActiveProjectContexts().get(0);
    }

    @Override
    protected Composite createMainComposite(Composite parent, List<String> columnKeys, List<ParameterType> parameterTypes) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setLayout((Layout)new FillLayout());
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        return scrolledComposite;
    }

    @Override
    public void createContents() {
        this.mainComposite = this.createMainComposite(this.parent, this.getColumnKeys(), this.getParameterTypes());
        if (!(this.mainComposite instanceof ScrolledComposite)) {
            S32DSWizardPlugin.log(new Exception("Composite must be a scrollable for NPW tree"));
            this.mainComposite.dispose();
            return;
        }
        ScrolledComposite scrolledComposite = (ScrolledComposite)this.mainComposite;
        Composite contentComposite = this.createContentComposite(this.mainComposite, 16, 1, true);
        scrolledComposite.setContent((Control)contentComposite);
        this.createProcessorSection(scrolledComposite, contentComposite);
        contentComposite.layout(true, true);
        contentComposite.pack();
        scrolledComposite.setMinSize(contentComposite.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.pack();
        for (Section section : this.sections) {
            this.setTraverseListener(section);
        }
    }

    private void createProcessorSection(ScrolledComposite scrolledComposite, Composite parent) {
        Section processorSection = this.createSection(parent, 24916, "", 1, true);
        this.multicore = this.createCheckbox((Composite)processorSection, this.getProcessorContext().getProcessor().getName(), true, e -> {
            this.switchProjectType(this.isAllAvalabileCoreSelected().equals((Object)MulticoreCheckboxState.ONLY_BOOT_CORE_CHECKED));
            if (e.getSource() instanceof Button) {
                Button button = (Button)e.getSource();
                button.setSelection(true);
            }
        });
        processorSection.setTextClient((Control)this.multicore);
        this.createMenu(scrolledComposite);
        Composite innerProcessorComposite = this.createContentComposite((Composite)processorSection, 0, 1, true);
        processorSection.setClient((Control)innerProcessorComposite);
        this.createGlobalSettingsSection(innerProcessorComposite);
        this.createCoresSections(scrolledComposite, innerProcessorComposite);
        innerProcessorComposite.setBackground(BACKGROUND_COLOR);
        innerProcessorComposite.pack();
        this.setTraverseListener(processorSection);
    }

    private void createMenu(final ScrolledComposite scrolledComposite) {
        MenuManager contextMenu = new MenuManager("#Page2Tree");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(menu -> {
            menu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IAction)new Action(Messages.Page2Tree_ExpandAll){

                public void run() {
                    Page2Tree.this.setExpansionToAllSections(true);
                    Page2Tree.this.resizeScrolledComposite(scrolledComposite);
                }
            });
            menu.add((IAction)new Action(Messages.Page2Tree_CollapseAll){

                public void run() {
                    Page2Tree.this.setExpansionToAllSections(false);
                    Page2Tree.this.resizeScrolledComposite(scrolledComposite);
                }
            });
        });
        Menu menu2 = contextMenu.createContextMenu((Control)this.multicore);
        this.multicore.setMenu(menu2);
    }

    private void setExpansionToAllSections(boolean state) {
        for (Section section : this.sections) {
            section.setExpanded(state);
        }
    }

    private void createCoresSections(ScrolledComposite scrolledComposite, Composite parent) {
        for (CProjectContext projectContext : this.getProcessorContext().getProjectContexts()) {
            Section section = this.createSectionWithCoreHeader(scrolledComposite, parent, projectContext);
            this.sections.add(section);
            Composite clientComposite = this.createContentCompositeForSection(scrolledComposite, section);
            for (Parameter parameter : projectContext.getParameters()) {
                this.createContentForParameter(parameter, projectContext, clientComposite);
            }
            if (!((CProjectContext)this.getProcessorContext().getProjectContexts().get(0)).equals(projectContext)) {
                section.setExpanded(false);
            }
            section.pack();
        }
    }

    private void createContentForParameter(Parameter parameter, CProjectContext projectContext, Composite parent) {
        if (!this.showCell(projectContext.getContextId(), parameter, projectContext, this.getProcessorContext())) {
            this.addParameterControl(new ParameterControl(projectContext.getContextId(), this.getProcessorContext(), parameter.getType(), null, 1, 0, false));
            return;
        }
        if (PARAMETER_PROJECT_NAME_TAG.equals(parameter.getTag()) || PARAMETER_CORE_TAG.equals(parameter.getTag()) || parameter.isSingle() && parameter.isApplyAll()) {
            return;
        }
        Label label = this.createLabel(parent, 0, parameter.getType().getDisplayName());
        ParameterControl parameterControl = this.createControl(projectContext.getContextId(), projectContext, parameter, 0, 0, parent);
        this.addParameterControl(parameterControl);
        if (this.checkEmptyLabel(parameterControl.getControl())) {
            label.dispose();
            parameterControl.getControl().dispose();
            return;
        }
        this.setControlProperties(projectContext, parameterControl);
    }

    private Composite createContentCompositeForSection(final ScrolledComposite scrolledComposite, Section section) {
        Composite clientComposite = this.createContentComposite((Composite)section, 0, 2, true);
        section.setClient((Control)clientComposite);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Page2Tree.this.resizeScrolledComposite(scrolledComposite);
            }
        });
        return clientComposite;
    }

    private Section createSectionWithCoreHeader(ScrolledComposite scrolledComposite, Composite parent, CProjectContext projectContext) {
        Section section = this.createSection(parent, 24916, "", 2, true);
        ParameterControl coreParameterControl = this.createControl(projectContext.getContextId(), projectContext, projectContext.getParameter(PARAMETER_CORE_TAG), 0, 0, (Composite)section);
        this.addParameterControl(coreParameterControl);
        this.setControlPropertiesForHeader(scrolledComposite, projectContext, section, coreParameterControl);
        section.setTextClient(coreParameterControl.getControl());
        return section;
    }

    private void createGlobalSettingsSection(Composite parent) {
        Section globalSettingsSection = this.createSection(parent, 16724, Messages.Page2Tree_GlobalSettings, 1, true);
        Composite globalSettingsClientComposite = this.createContentComposite((Composite)globalSettingsSection, 0, 2, true);
        globalSettingsSection.setClient((Control)globalSettingsClientComposite);
        for (Parameter parameter : this.bootCoreContext.getParameters()) {
            if (!parameter.isSingle() || !parameter.isApplyAll()) continue;
            this.createUIForSingleParameter(globalSettingsClientComposite, parameter);
        }
        if (globalSettingsClientComposite.getChildren().length == 0) {
            globalSettingsClientComposite.dispose();
            globalSettingsSection.dispose();
            return;
        }
        this.sections.add(globalSettingsSection);
    }

    private boolean checkEmptyLabel(Control control) {
        if (!(control instanceof Label)) {
            return false;
        }
        return ((Label)control).getText().isEmpty();
    }

    private void switchProjectType(boolean setTo) {
        List<ParameterControl> parameterControls = this.getControls();
        for (ParameterControl parameterControl : parameterControls) {
            Button button;
            if (!parameterControl.getParameterType().getTag().equals(PARAMETER_CORE_TAG) || this.bootCoreContext.equals(parameterControl.getProjectContext()) || !(button = (Button)parameterControl.getControl()).isEnabled()) continue;
            button.setSelection(setTo);
            button.notifyListeners(13, new Event());
        }
    }

    private void setControlPropertiesForHeader(final ScrolledComposite scrolledComposite, CProjectContext projectContext, final Section section, ParameterControl headerParameterControl) {
        if (headerParameterControl == null || headerParameterControl.getControl() == null) {
            return;
        }
        headerParameterControl.getControl().setEnabled(projectContext.isActive());
        headerParameterControl.getControl().setToolTipText(projectContext.getProjectName());
        headerParameterControl.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.getSource() instanceof Button) {
                    section.setExpanded(((Button)e.getSource()).getSelection());
                    Page2Tree.this.resizeScrolledComposite(scrolledComposite);
                }
            }
        });
        if (headerParameterControl.getControl() instanceof Button) {
            ((Button)headerParameterControl.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    switch (Page2Tree.this.isAllAvalabileCoreSelected()) {
                        case CHECKED: {
                            Page2Tree.this.multicore.setGrayed(false);
                            Page2Tree.this.multicore.setSelection(true);
                            break;
                        }
                        case ONLY_BOOT_CORE_CHECKED: 
                        case GRAYED: {
                            Page2Tree.this.multicore.setGrayed(true);
                            Page2Tree.this.multicore.setSelection(true);
                            break;
                        }
                        default: {
                            Page2Tree.this.multicore.setSelection(false);
                        }
                    }
                }
            });
        }
    }

    private MulticoreCheckboxState isAllAvalabileCoreSelected() {
        List<ParameterControl> parameterControls = ParameterControl.filterControls(this.getControls(), PARAMETER_CORE_TAG);
        int count = 0;
        int inactive = 0;
        for (ParameterControl parameterControl : parameterControls) {
            if (parameterControl.getControl().isEnabled() && ((Button)parameterControl.getControl()).getSelection()) {
                ++count;
            }
            if (parameterControl.getControl().isEnabled()) continue;
            ++inactive;
        }
        return count + inactive == parameterControls.size() ? MulticoreCheckboxState.CHECKED : (count == 1 ? MulticoreCheckboxState.ONLY_BOOT_CORE_CHECKED : MulticoreCheckboxState.GRAYED);
    }

    private void setControlProperties(CProjectContext projectContext, ParameterControl parameterControl) {
        parameterControl.getControl().setBackground(BACKGROUND_COLOR);
        parameterControl.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        parameterControl.getControl().setEnabled(projectContext.isActive());
    }

    private void createUIForSingleParameter(Composite parent, Parameter parameter) {
        this.createLabel(parent, 0, parameter.getType().getDisplayName());
        ParameterControl parameterControl = this.createControl(this.bootCoreContext.getContextId(), this.bootCoreContext, parameter, 0, 0, parent);
        this.addParameterControl(parameterControl);
        parameterControl.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        parameterControl.getControl().setBackground(BACKGROUND_COLOR);
    }

    private Composite createContentComposite(Composite parent, int style, int nrOfColumn, boolean eqColumnWidth) {
        return (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)style).layout((Layout)new GridLayout(nrOfColumn, eqColumnWidth))).layoutData((Object)new GridData(4, 4, true, true))).create((Widget)parent);
    }

    private Section createSection(Composite parent, int style, String text, int nrOfColumn, boolean eqWidthColumn) {
        return (Section)((SectionFactory)((SectionFactory)((SectionFactory)SectionFactory.newSection((int)style).title(text).background(BACKGROUND_COLOR)).layout((Layout)new GridLayout(nrOfColumn, eqWidthColumn))).layoutData((Object)new GridData(4, 4, true, false))).create((Widget)parent);
    }

    private Label createLabel(Composite parent, int style, String text) {
        return (Label)((LabelFactory)((LabelFactory)WidgetFactory.label((int)style).text(text).background(BACKGROUND_COLOR)).layoutData((Object)new GridData(4, 4, true, true))).create((Widget)parent);
    }

    private Button createCheckbox(Composite parent, String text, boolean defaultState, Consumer<SelectionEvent> onSelect) {
        Button button = (Button)((ButtonFactory)WidgetFactory.button((int)32).text(text).onSelect(onSelect).layoutData((Object)new GridData(4, 4, true, true))).create((Widget)parent);
        button.setSelection(defaultState);
        return button;
    }

    private void resizeScrolledComposite(ScrolledComposite scrolledComposite) {
        scrolledComposite.setMinSize(scrolledComposite.getContent().computeSize(-1, -1));
        scrolledComposite.layout(true, true);
    }

    private static enum MulticoreCheckboxState {
        ONLY_BOOT_CORE_CHECKED,
        CHECKED,
        GRAYED;

    }
}

