/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.tcmodification.IConfigurationModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolChainModificationManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AddConfigTC
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (template.getValueStore().get("EARLY_DONE") != null) {
            return;
        }
        if (args == null || args.length < 5) {
            S32DSWizardPlugin.logWarning("Data for AddConfigTC should contain more input parameters !");
            return;
        }
        Params params = new Params(args);
        ICProjectDescription projectDesc = params.getProjectDescription();
        try {
            ICConfigurationDescription confDesc = params.getConfigurationDescription();
            ICConfigurationDescription newConfDesc = projectDesc.createConfiguration(params.getId(), params.getName(), confDesc);
            IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)newConfDesc);
            IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
            IConfigurationModification toolChainModification = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
            toolChainModification.setToolChain(params.getToolChain());
            toolChainModification.apply();
            CProjectDescriptionManager.getInstance().setProjectDescription(params.getProject(), projectDesc);
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
    }

    private static class Params {
        private String id = null;
        private String name = null;
        private String superName = null;
        private String projectName = null;
        private String toolchain = null;
        private String target = null;

        public Params(ProcessArgument[] args) {
            ProcessArgument[] processArgumentArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessArgument pa = processArgumentArray[n2];
                pa.resolve();
                if (pa.getParameterType() == 1) {
                    String argName = pa.getName();
                    if ("id".equals(argName)) {
                        this.id = pa.getSimpleValue();
                    }
                    if ("name".equals(argName)) {
                        this.name = pa.getSimpleValue();
                    }
                    if ("superName".equals(argName)) {
                        this.superName = pa.getSimpleValue();
                    }
                    if ("projectName".equals(argName)) {
                        this.projectName = pa.getSimpleValue();
                    }
                    if ("toolchain".equals(argName)) {
                        this.toolchain = pa.getSimpleValue();
                    }
                    if ("target".equals(argName)) {
                        this.target = pa.getSimpleValue();
                    }
                }
                ++n2;
            }
        }

        public String getId() {
            return this.id;
        }

        public ICProjectDescription getProjectDescription() {
            return CProjectDescriptionManager.getInstance().getProjectDescription(this.getProject());
        }

        private ICConfigurationDescription getConfigurationDescription() throws CoreException {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getProjectDescription().getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
                if (c.getName().equals(this.getSuperName())) {
                    return c;
                }
                ++n2;
            }
            throw new CoreException((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", "Can't find Configuration Description: " + this.getSuperName()));
        }

        public String getSuperName() {
            return this.superName;
        }

        public String getName() {
            return this.name;
        }

        public IProject getProject() {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        }

        private IToolChain getToolChain() {
            HWModel model = Hardware.instance().getModel(this.target);
            return model.getRegistry().getToolChain(this.toolchain);
        }
    }
}

