/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import java.util.Arrays;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class DisabledBuild
extends ProcessRunner {
    private static final String BUILD_ARG = "disabledBuild";
    private static final String PROJECT_NAME_ARG = "projectName";
    private static final String IGNORED_BUILDER = "org.eclipse.cdt.managedbuilder.core.genmakebuilder";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (template.getValueStore().get("EARLY_DONE") != null) {
            return;
        }
        if (args == null || args.length < 2) {
            S32DSWizardPlugin.logWarning(Messages.DisabledBuild_Error_Parameters);
            return;
        }
        boolean build = false;
        String projectName = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument pa = processArgumentArray[n2];
            pa.resolve();
            String name = pa.getName();
            if (pa.getParameterType() == 1) {
                if (BUILD_ARG.equals(name)) {
                    build = Boolean.valueOf(pa.getSimpleValue());
                } else if (PROJECT_NAME_ARG.equals(name)) {
                    projectName = pa.getSimpleValue();
                }
            }
            ++n2;
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!build) {
            try {
                IProjectDescription descr = proj.getDescription();
                ICommand[] buildSpec = descr.getBuildSpec();
                ICommand[] newBuildSpec = (ICommand[])Arrays.stream(buildSpec).filter(c -> !IGNORED_BUILDER.equals(c.getBuilderName())).toArray(ICommand[]::new);
                descr.setBuildSpec(newBuildSpec);
                proj.setDescription(descr, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                String message = NLS.bind((String)Messages.DisabledBuild_Error_Build_Spec, projectName);
                Status status = new Status(4, "com.freescale.s32ds.cross.wizard", message, (Throwable)e);
                S32DSWizardPlugin.log((IStatus)status);
                e.printStackTrace();
            }
        }
    }
}

