/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SetReferencesCfgInfo
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (args == null || args.length < 2) {
            S32DSWizardPlugin.logWarning("Data for SetReferencesCfgInfo should contain more input parameters !");
            return;
        }
        Params params = new Params(args);
        ICProjectDescription projectDesc = params.getProjectDescription();
        String cfgSet = null;
        IProject project = params.getProject();
        ICProjectDescription des = CProjectDescriptionManager.getInstance().getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = des.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            if (c.getName().equals(params.getName())) {
                cfgSet = c.getId();
                break;
            }
            ++n2;
        }
        if (cfgSet == null) {
            return;
        }
        try {
            ICConfigurationDescription confDesc = params.getConfigurationDescription();
            LinkedHashMap<String, String> refs = new LinkedHashMap<String, String>();
            refs.put(params.projectName, cfgSet);
            confDesc.setReferenceInfo(refs);
            CoreModel.getDefault().setProjectDescription(project, projectDesc);
            IProjectDescription description = project.getDescription();
            if (Stream.of(description.getReferencedProjects()).anyMatch(arg_0 -> ((IProject)project).equals(arg_0))) {
                IProject[] oldRefs = description.getReferencedProjects();
                IProject[] newRefs = new IProject[oldRefs.length - 1];
                int i = 0;
                int j = 0;
                while (i < oldRefs.length) {
                    if (oldRefs[i] != project) {
                        newRefs[j] = oldRefs[i];
                        ++j;
                    }
                    ++i;
                }
                description.setReferencedProjects(newRefs);
                project.setDescription(description, monitor);
            }
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
    }

    private static class Params {
        private String id = null;
        private String name = null;
        private String projectName = null;
        private final ICProjectDescription projectDesc;
        private final IProject project;

        public Params(ProcessArgument[] args) {
            ProcessArgument[] processArgumentArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessArgument pa = processArgumentArray[n2];
                pa.resolve();
                if (pa.getParameterType() == 1) {
                    String argName = pa.getName();
                    if ("id".equals(argName)) {
                        this.id = pa.getSimpleValue();
                    }
                    if ("name".equals(argName)) {
                        this.name = pa.getSimpleValue();
                    }
                    if ("projectName".equals(argName)) {
                        this.projectName = pa.getSimpleValue();
                    }
                }
                ++n2;
            }
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
            this.projectDesc = CoreModel.getDefault().getProjectDescription(this.getProject(), true);
        }

        public String getId() {
            return this.id;
        }

        public ICProjectDescription getProjectDescription() {
            return this.projectDesc;
        }

        public ICConfigurationDescription getConfigurationDescription() throws CoreException {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getProjectDescription().getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
                if (c.getName().equals(this.getId())) {
                    return c;
                }
                ++n2;
            }
            throw new CoreException((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", "Can't find Configuration Description: " + this.getId()));
        }

        public String getName() {
            return this.name;
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

