/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.backend.IWizardWithData;
import com.freescale.s32ds.cross.wizard.backend.WizardBackend;
import com.freescale.s32ds.cross.wizard.backend.WizardUtils;
import com.freescale.s32ds.cross.wizard.template.Condition;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUIUtil;
import org.eclipse.cdt.ui.templateengine.pages.UIWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateUtils {
    public static final String EARLY = "EARLY_DONE";
    public static final String[] EARLIES = new String[]{".SetLaunchConfigDebugId", ".AppendVar", ".ReplaceVariable", ".AddConfig", ".AddConfigTC", ".AddConfigID", ".DelConfig", ".SetLaunchConfigAttrId", ".SetPathMapping", ".SetConfigurationName", ".SetContentTypeMapping", ".DisabledBuild"};
    private static final String PROPERTY = "property";

    public static void processTemplate(CfgHolder[] cfgs, IWizardWithData w, CProjectContext projectContext, IProject project, WizardBackend wb) {
        int n;
        Map<String, String> projectData = w != null ? w.getProjectData((ProjectContext)projectContext) : wb.getProjectData((ProjectContext)projectContext);
        Template template = projectContext.getTargetTemplate();
        if (template == null) {
            return;
        }
        Map valueStore = template.getValueStore();
        if (w != null) {
            IWizardPage[] iWizardPageArray = template.getTemplateWizardPages(w.getStartingPage(), null, (IWizard)w);
            n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                if (page instanceof UIWizardPage) {
                    valueStore.putAll(((UIWizardPage)page).getPageData());
                }
                if (page instanceof IWizardDataPage) {
                    valueStore.putAll(((IWizardDataPage)page).getPageData());
                }
                ++n2;
            }
        }
        valueStore.putAll(projectData);
        ArrayList<IConfiguration> configs = new ArrayList<IConfiguration>();
        CfgHolder[] cfgHolderArray = cfgs;
        int n3 = cfgs.length;
        n = 0;
        while (n < n3) {
            CfgHolder cfg = cfgHolderArray[n];
            configs.add(cfg.getConfiguration());
            ++n;
        }
        try {
            Map<String, List<ILanguageSettingsProvider>> langSettingsProviders = WizardUtils.removeLanguageSettingsProviders(project);
            template.getTemplateInfo().setConfigurations(configs);
            TemplateUtils.earlyProcesses(template, w != null);
            TemplateUtils.normalProcesses(template, w != null);
            WizardUtils.addLanguageSettingsProviders(langSettingsProviders, project);
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
    }

    private static void earlyProcesses(Template template, boolean isUIEnabled) {
        TemplateUtils.runTasks((TemplateCore)template, true, (IProgressMonitor)new NullProgressMonitor(), isUIEnabled);
        template.getValueStore().put(EARLY, EARLY);
    }

    private static void normalProcesses(final Template template, final boolean isUIEnabled) {
        WorkspaceModifyOperation wmo = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                TemplateUtils.runTasks((TemplateCore)template, false, monitor, isUIEnabled);
            }
        };
        try {
            try {
                wmo.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite.getTargetException());
            }
        }
        finally {
            template.getValueStore().remove(EARLY);
        }
    }

    private static void handleProcesses(TemplateCore template, boolean isEarly, NodeList nodelist, List<Condition> tasks, boolean isUIEnabled) {
        if (nodelist == null) {
            return;
        }
        ArrayList<Element> nodes = new ArrayList<Element>();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node n = nodelist.item(i);
            String s = n.getNodeName();
            if (n.getNodeType() == 1 && ("process".equals(s) || "if".equals(s))) {
                nodes.add((Element)n);
            }
            ++i;
        }
        for (Element el : nodes) {
            String nn = el.getNodeName();
            if (nn.equals("if")) {
                Condition cpg = new Condition(template, el);
                if (!cpg.isConditionValueTrue()) continue;
                TemplateUtils.handleProcesses(template, isEarly, el.getChildNodes(), tasks, isUIEnabled);
                continue;
            }
            if (!nn.equals("process") || isEarly && !TemplateUtils.isForeRunner(el) || !isUIEnabled && el.getAttribute("type").toLowerCase().contains("openfiles")) continue;
            tasks.add(new Condition(template, new Element[]{el}));
        }
    }

    private static void runTasks(TemplateCore template, boolean isEarly, IProgressMonitor monitor, boolean isUIEnabled) {
        NodeList nodelist = template.getTemplateDescriptor().getRootElement().getChildNodes();
        ArrayList<Condition> tasks = new ArrayList<Condition>();
        TemplateUtils.handleProcesses(template, isEarly, nodelist, tasks, isUIEnabled);
        try {
            for (Condition cpg : tasks) {
                List res = cpg.process(monitor);
                for (IStatus ist : res) {
                    if (ist.getSeverity() < 4) continue;
                    TemplateEngineUIUtil.showError((String)("TEMPLATE err: " + ist.getMessage()), (Throwable)ist.getException());
                }
            }
        }
        catch (ProcessFailureException e) {
            TemplateEngineUIUtil.showError((String)e.getMessage(), (Throwable)e.getCause());
        }
    }

    private static boolean isForeRunner(Element el) {
        if (el.hasAttribute("type")) {
            String type = el.getAttribute("type");
            String[] stringArray = EARLIES;
            int n = EARLIES.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (type.endsWith(s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static IWizardPage getTemplatePages(Template t, IWizardPage p, Composite w) {
        List els = t.getTemplateDescriptor().getPropertyGroupList();
        String[][] descrs = new String[els.size()][];
        int cntr = 0;
        for (Element el : els) {
            ++cntr;
            NodeList nl = el.getChildNodes();
            if (nl == null) continue;
            descrs[cntr - 1] = new String[nl.getLength()];
            int cntn = 0;
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n != null && n.hasAttributes() && PROPERTY.equals(n.getNodeName())) {
                    String s = n.getAttributes().getNamedItem("description").getNodeValue();
                    try {
                        s = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
                    }
                    catch (CoreException e) {
                        S32DSWizardPlugin.log(e);
                    }
                    descrs[cntr - 1][cntn++] = s;
                }
                ++i;
            }
        }
        IWizardPage[] wps = t.getTemplateWizardPages(p, null, p.getWizard());
        int cntP = -1;
        int cntC = -1;
        IWizardPage[] iWizardPageArray = wps;
        int n = wps.length;
        int n2 = 0;
        while (n2 < n) {
            Control[] ctrls;
            IWizardPage wp = iWizardPageArray[n2];
            ++cntP;
            UIWizardPage page = (UIWizardPage)wp;
            Composite com = (Composite)page.getControl();
            if (com != null && (ctrls = com.getChildren()) != null && ctrls.length != 0 && ctrls[ctrls.length - 1].getData() != Boolean.FALSE) {
                Composite z = new Composite(com, 0);
                GridData gd = new GridData(4, 4, true, true, 2, 1);
                gd.minimumHeight = 1;
                gd.minimumWidth = w.getParent().getBounds().x - 50;
                z.setLayoutData((Object)gd);
                final Text text = new Text(com, 2634);
                text.setData((Object)Boolean.FALSE);
                text.setText(descrs[cntP][0]);
                gd = new GridData(4, 4, true, false, 2, 1);
                gd.verticalIndent = 30;
                gd.minimumHeight = 100;
                gd.heightHint = 100;
                text.setLayoutData((Object)gd);
                gd.minimumWidth = 500;
                gd.widthHint = 500;
                Control[] controlArray = ctrls;
                int n3 = ctrls.length;
                int n4 = 0;
                while (n4 < n3) {
                    Composite c2;
                    Control[] cts2;
                    Control c = controlArray[n4];
                    if (c instanceof Composite && (cts2 = (c2 = (Composite)c).getChildren()) != null && cts2.length != 0) {
                        Control[] controlArray2 = cts2;
                        int n5 = cts2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Control combo = controlArray2[n6];
                            if (descrs[cntP][++cntC] != null) {
                                combo.setData((Object)descrs[cntP][cntC]);
                                combo.setToolTipText(descrs[cntP][cntC]);
                                Point pt = combo.getSize();
                                pt.x = w.getParent().getSize().x - 20;
                                combo.setSize(pt);
                            }
                            combo.addFocusListener((FocusListener)new FocusAdapter(){

                                public void focusGained(FocusEvent e) {
                                    Object o = e.widget.getData();
                                    if (o instanceof String) {
                                        text.setText((String)o);
                                    } else {
                                        text.setText("");
                                    }
                                }
                            });
                            ++n6;
                        }
                    }
                    ++n4;
                }
                Composite pc = com.getParent();
                pc.setSize(com.getShell().getSize().x - 10, pc.getSize().y);
                pc.pack(true);
            }
            ++n2;
        }
        if (wps.length > 0) {
            return wps[0];
        }
        return null;
    }
}

