/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.provider.core;

import com.nxp.s32ds.cle.runtime.migration.entity.MigrationEntityDescriptor;
import com.nxp.s32ds.cle.runtime.migration.entity.core.MigrationEntityDescriptors;
import com.nxp.s32ds.cle.runtime.migration.internal.provider.core.MigrationProviderActivator;
import com.nxp.s32ds.cle.runtime.migration.provider.MigrationProviderDescriptor;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class MigrationProviderConditions {
    private static final String REGEX_COMMA = ",";

    public static boolean isApplicable(MigrationProviderDescriptor descriptor, Map<String, Object> attributes) {
        if (!MigrationProviderConditions.checkMigrationEntityExistance(descriptor.getId())) {
            MigrationProviderActivator.getInstance().logError("Should exist at least one migration entity for provider id:" + descriptor.getId());
            return false;
        }
        if (descriptor.getMigrationProvider() == null) {
            MigrationProviderActivator.getInstance().logError("Found unresolved migration provider by id: " + descriptor.getId());
            return false;
        }
        String[] sources = descriptor.getSourceId().split(REGEX_COMMA);
        String[] targets = descriptor.getTargetId().split(REGEX_COMMA);
        int i = 0;
        while (i < sources.length) {
            String t = "";
            if (i < targets.length) {
                t = targets[i];
            }
            if (descriptor.getMigrationProvider().isApplicable(sources[i], t, attributes)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean checkMigrationEntityExistance(String providerId) {
        List entities = MigrationEntityDescriptors.getMigrationEntityDescriptorsByPorvider((String)providerId);
        if (entities == null || entities.isEmpty()) {
            return false;
        }
        for (MigrationEntityDescriptor entity : entities) {
            if (entity.getMigrationEntity() != null || entity.getManifest() != null && !entity.getManifest().isEmpty()) continue;
            IStatus status = MigrationProviderActivator.getInstance().createStatus(1, NLS.bind((String)"Migration Entity does not implemented for descriptor id {0}", (Object)entity.getId()));
            MigrationProviderActivator.getInstance().log(status);
        }
        return true;
    }
}

