/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.crosstriggering;

import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerLaunchUtils;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DebuggerUIActivator;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.crosstriggering.CrossTriggeringCommonHandler;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;

public class CrossTriggeringRunHandler
extends CrossTriggeringCommonHandler {
    private static final String CROSSTRIGGER_RUN_COMMAND = "xt_run";
    private static final String GDB_RUN_COMMAND = "-exec-continue";

    @Override
    protected String generateCommand(ExecutionEvent event) {
        return state.equals((Object)CrossTriggeringCommonHandler.State.CONFIGURED) ? CROSSTRIGGER_RUN_COMMAND : null;
    }

    @Override
    protected void afterCommandProceeding() {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            S32DSGdbLaunch s32dsLaunch;
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof S32DSGdbLaunch && !S32DSGdbLaunch.isShutdowned((ILaunch)(s32dsLaunch = (S32DSGdbLaunch)launch))) {
                DsfServicesTracker tracker = new DsfServicesTracker(S32DebuggerUIActivator.getInstance().getContext(), s32dsLaunch.getSession().getId());
                try {
                    IRunControl runControl = (IRunControl)tracker.getService(IRunControl.class);
                    if (runControl.isSuspended(null)) {
                        S32DebuggerLaunchUtils.queueCommand((S32DSGdbLaunch)s32dsLaunch, (String)GDB_RUN_COMMAND);
                    }
                }
                finally {
                    tracker.dispose();
                }
            }
            ++n2;
        }
    }
}

