/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering;

import com.nxp.s32ds.cle.runtime.hardware.registry.ClusterDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DebuggerUIActivator;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.crosstriggering.CrossTriggeringCommonHandler;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.CrossTriggeringButtonsCondition;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.CrossTriggeringMessages;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.CrossTriggeringState;
import com.nxp.s32ds.debug.ide.s32debugger.ui.crosstriggering.memento.CrossTriggeringContextMemento;
import com.nxp.s32ds.ext.ide.ui.dialogs.AbstractCheckBoxCellEditingSupport;
import com.nxp.s32ds.ext.ide.ui.dialogs.AbstractCheckBoxCellLabelProvider;
import com.nxp.s32ds.ext.ide.ui.dialogs.AbstractTableDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CrossTriggeringSelectionDialog
extends AbstractTableDialog {
    private static final int defaultRowsNumber = 8;
    private Button selectSourcesButton;
    private Button selectDestinationsButton;
    private final List<CrossTriggeringState> tableData = new ArrayList<CrossTriggeringState>();
    private List<CrossTriggeringState> activeTableData = new ArrayList<CrossTriggeringState>();
    private String workingDeviceId;

    public CrossTriggeringSelectionDialog(Shell parentShell) {
        super(parentShell, CrossTriggeringMessages.CrossTriggeringSetupDialog_title, CrossTriggeringMessages.CrossTriggeringSetupDialog_message, 8);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.selectSourcesButton = this.createButton(parent, 18, CrossTriggeringMessages.CrossTriggeringSetupDialog_select_deselect_all_sources, false);
        this.selectSourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean select_deselect_operation = !CrossTriggeringSelectionDialog.this.isAllSourcesSellected();
                CrossTriggeringSelectionDialog.this.activeTableData.forEach(stateObject -> {
                    if (stateObject.isSource() != select_deselect_operation) {
                        stateObject.setSource(select_deselect_operation);
                        CrossTriggeringSelectionDialog.this.tableViewer.update(stateObject, null);
                    }
                });
                CrossTriggeringSelectionDialog.this.getButton(0).setEnabled(CrossTriggeringSelectionDialog.this.isActiveOkButton());
            }
        });
        this.selectDestinationsButton = this.createButton(parent, 19, CrossTriggeringMessages.CrossTriggeringSetupDialog_select_deselect_all_destinations, false);
        this.selectDestinationsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean select_deselect_operation = !CrossTriggeringSelectionDialog.this.isAllDestinationSellected();
                CrossTriggeringSelectionDialog.this.activeTableData.forEach(stateObject -> {
                    if (stateObject.isDestination() != select_deselect_operation) {
                        stateObject.setDestination(select_deselect_operation);
                        CrossTriggeringSelectionDialog.this.tableViewer.update(stateObject, null);
                    }
                });
                CrossTriggeringSelectionDialog.this.getButton(0).setEnabled(CrossTriggeringSelectionDialog.this.isActiveOkButton());
            }
        });
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(this.isActiveOkButton());
    }

    private boolean isActiveOkButton() {
        boolean isSomeSourceChecked = false;
        boolean isSomeDestinationChecked = false;
        for (CrossTriggeringState state : this.activeTableData) {
            isSomeSourceChecked = isSomeSourceChecked || state.isSource();
            boolean bl = isSomeDestinationChecked = isSomeDestinationChecked || state.isDestination();
        }
        return isSomeDestinationChecked && isSomeSourceChecked;
    }

    private boolean isAllSourcesSellected() {
        for (CrossTriggeringState crossTriggeringState : this.activeTableData) {
            if (crossTriggeringState.isSource()) continue;
            return false;
        }
        return true;
    }

    private boolean isAllDestinationSellected() {
        for (CrossTriggeringState crossTriggeringState : this.activeTableData) {
            if (crossTriggeringState.isDestination()) continue;
            return false;
        }
        return true;
    }

    public void createTableColumns(Composite parent) {
        TableColumnLayout tableLayout = new TableColumnLayout();
        parent.setLayout((Layout)tableLayout);
        ColumnWeightData columnData = new ColumnWeightData(33, 40, true);
        TableViewerColumn column = this.createColumn(tableLayout, columnData, 0, CrossTriggeringMessages.CrossTriggeringSetupDialog_cores_column);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                String deviceCoreId = ((CrossTriggeringState)element).getDeviceCoreId();
                return String.valueOf(DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId).getName()) + " " + CrossTriggeringSelectionDialog.this.getClusterName(deviceCoreId);
            }
        });
        column = this.createColumn(tableLayout, columnData, 0, CrossTriggeringMessages.CrossTriggeringSetupDialog_sources_column);
        column.setLabelProvider((CellLabelProvider)new AbstractCheckBoxCellLabelProvider<Object>(){

            public boolean isEnabled(Object element) {
                return ((CrossTriggeringState)element).isSource();
            }
        });
        column.setEditingSupport((EditingSupport)new AbstractCheckBoxCellEditingSupport(this.tableViewer){

            protected Object getValue(Object element) {
                return ((CrossTriggeringState)element).isSource();
            }

            protected void setValue(Object element, Object value) {
                ((CrossTriggeringState)element).setSource((Boolean)value);
                CrossTriggeringSelectionDialog.this.getButton(0).setEnabled(CrossTriggeringSelectionDialog.this.isActiveOkButton());
                CrossTriggeringSelectionDialog.this.tableViewer.update(element, null);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        column = this.createColumn(tableLayout, columnData, 0, CrossTriggeringMessages.CrossTriggeringSetupDialog_destinations_column);
        column.setLabelProvider((CellLabelProvider)new AbstractCheckBoxCellLabelProvider<CrossTriggeringState>(){

            public boolean isEnabled(CrossTriggeringState element) {
                return element.isDestination();
            }
        });
        column.setEditingSupport((EditingSupport)new AbstractCheckBoxCellEditingSupport(this.tableViewer){

            protected Object getValue(Object element) {
                return ((CrossTriggeringState)element).isDestination();
            }

            protected void setValue(Object element, Object value) {
                ((CrossTriggeringState)element).setDestination((Boolean)value);
                CrossTriggeringSelectionDialog.this.getButton(0).setEnabled(CrossTriggeringSelectionDialog.this.isActiveOkButton());
                CrossTriggeringSelectionDialog.this.tableViewer.update(element, null);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
    }

    private String getClusterName(String deviceCoreId) {
        String clusterId = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId).getClusterId();
        List cluster = DeviceDescriptors.getClusterDescriptorsByDeviceId((String)this.workingDeviceId);
        for (ClusterDescriptor clusterDescriptor : cluster) {
            if (!clusterDescriptor.getId().equals(clusterId)) continue;
            return clusterDescriptor.getName();
        }
        return "";
    }

    public void setContent(TableViewer tableViewer) {
        Set launches = Arrays.stream(DebugPlugin.getDefault().getLaunchManager().getLaunches()).filter(launch -> launch instanceof S32DSGdbLaunch && !S32DSGdbLaunch.isShutdowned((ILaunch)launch)).collect(Collectors.toSet());
        ArrayList<String> listDeviceCoreIds = new ArrayList<String>();
        for (ILaunch launch2 : launches) {
            ILaunchConfiguration configuration = ((S32DSGdbLaunch)launch2).getLaunchConfiguration();
            try {
                String deviceCoreId = configuration.getAttribute("com.nxp.s32ds.debug.ide.s32debugger.core.deviceCoreId", "");
                if (deviceCoreId.isEmpty()) continue;
                listDeviceCoreIds.add(deviceCoreId);
            }
            catch (CoreException e) {
                S32DebuggerUIActivator.getInstance().log(e.getStatus());
            }
        }
        if (!listDeviceCoreIds.isEmpty()) {
            DeviceCoreDescriptor descriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)((String)listDeviceCoreIds.get(0)));
            this.workingDeviceId = descriptor.getDeviceId();
        }
        this.getCrossTriggerStates();
        this.activeTableData = this.tableData.stream().filter(crossTriggerStates -> listDeviceCoreIds.contains(crossTriggerStates.getDeviceCoreId())).collect(Collectors.toList());
        tableViewer.setInput(this.activeTableData);
    }

    private void getCrossTriggerStates() {
        new CrossTriggeringContextMemento(this.workingDeviceId).restoreFromMemento(this.tableData);
        DeviceDescriptors.getDeviceCoreDescriptors((String)this.workingDeviceId).forEach(desc -> {
            String curDeviceCoreId = desc.getId();
            if (!this.tableData.stream().filter(state -> state.getDeviceCoreId().equals(curDeviceCoreId)).findAny().isPresent()) {
                this.tableData.add(new CrossTriggeringState(desc.getId()));
            }
        });
    }

    public void setContentProvider(TableViewer tableViewer) {
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }
        });
    }

    protected void okPressed() {
        CrossTriggeringButtonsCondition.enableStopButton(true);
        CrossTriggeringCommonHandler.forceHandle(CrossTriggeringMessages.CrossTriggerEraseId);
        CrossTriggeringButtonsCondition.enableStopButton(false);
        super.okPressed();
    }

    public List<CrossTriggeringState> getCrossTriggeringStates() {
        return this.activeTableData;
    }

    public String getWorkingDeviceId() {
        return this.workingDeviceId;
    }
}

