/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.s32debugger.launch.checkers;

import com.nxp.s32ds.cle.debug.s32debugger.S32DebuggerActivator;
import com.nxp.s32ds.cle.debug.s32debugger.launch.markers.S32DebuggerLaunchConfigurationGdbPathMarker;
import com.nxp.s32ds.ext.cdt.checkers.core.CdtLaunchConfigurationAbstractChecker;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class S32DebuggerLaunchConfigurationGdbClientChecker
extends CdtLaunchConfigurationAbstractChecker
implements IResourceChecker {
    private static final String DOT_EXE = ".exe";

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        return this.checkLaunchConfigurationFiles(resource);
    }

    protected IStatus check(List<IFile> listLaunchFiles, IProject project) {
        MultiStatus ms = new MultiStatus(S32DebuggerActivator.getInstance().getBundleId(), 0, "", null);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        for (IFile launchFile : listLaunchFiles) {
            if (!launchFile.exists()) continue;
            ILaunchConfiguration launchConfiguration = launchManager.getLaunchConfiguration(launchFile);
            try {
                String lcType = launchConfiguration.getType().getIdentifier();
                if (!"com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType".equals(lcType) && !"com.nxp.s32ds.debug.ide.s32debugger.flash.core.s32DebuggerFlashProgrammerLaunchConfigurationType".equals(lcType)) continue;
                if (S32DebuggerLaunchConfigurationGdbClientChecker.hasInvalidGdbClientPath(launchConfiguration)) {
                    if (S32DebuggerLaunchConfigurationGdbPathMarker.containsMarker((IResource)launchFile)) continue;
                    ms.add(S32DebuggerLaunchConfigurationGdbPathMarker.createMarker((IResource)launchFile, project));
                    continue;
                }
                S32DebuggerLaunchConfigurationGdbPathMarker.removeMarkers((IResource)launchFile);
            }
            catch (CoreException ce) {
                S32DebuggerActivator.getInstance().log(ce.getStatus());
            }
        }
        return ms;
    }

    private static boolean hasInvalidGdbClientPath(ILaunchConfiguration launchConfiguration) {
        String gdbPath;
        block4: {
            try {
                gdbPath = launchConfiguration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "");
                if (!gdbPath.isEmpty()) break block4;
                return true;
            }
            catch (CoreException ce) {
                S32DebuggerActivator.getInstance().log(ce.getStatus());
                return true;
            }
        }
        String gdbPathResolved = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(gdbPath);
        if ("win32".equals(Platform.getOS()) && !gdbPathResolved.endsWith(DOT_EXE)) {
            gdbPathResolved = gdbPathResolved.concat(DOT_EXE);
        }
        return !Files.exists(Paths.get(gdbPathResolved, new String[0]), new LinkOption[0]);
    }
}

