/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.connection.LinuxDebuggerUsbConnection;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap.S32DebuggerTapUsbDeviceAccessor;
import java.util.Collection;
import java.util.List;

public class S32DebuggerTapUsbDeviceAccessorLinuxImpl
extends LinuxDebuggerUsbConnection {
    private static final String GREP_USB_NUMBERS_BY_VENDOR = "grep %s /sys/bus/usb/devices/*/idVendor | awk -F'/' '{print $6}'";
    private static final String DMESG_HARDWARE_ADDRESS_REQUEST = "dmesg | grep -e '%s.*register' | awk -F', ' '{print $3}'";
    private static final String DMESG_USB_DEVICE_SERIAL_NUMBER = "dmesg | grep -e '%s.*SerialNumber:' | awk -F': ' '{print $3}'";

    public String getConnectionString(DebuggerConnectionDescriptor deviceDescriptor, DeviceConnection connectionData) {
        String vid = S32DebuggerTapUsbDeviceAccessor.getVidOfConnection(deviceDescriptor, connectionData);
        String pid = S32DebuggerTapUsbDeviceAccessor.getPidByVid(vid);
        String virtualPrefix = S32DebuggerTapUsbDeviceAccessor.getVirtualPrefix(vid);
        String deviceSerial = connectionData.getDeviceConnectionData();
        Collection devices = this.getConnectedDevices(deviceDescriptor, vid, pid);
        for (DeviceConnection device : devices) {
            String ethernetMAC;
            if (!device.getDeviceConnectionData().equals(deviceSerial)) continue;
            if (device.isUsbConnection() && (ethernetMAC = device.getDeviceConnectionData()) != null && !ethernetMAC.isEmpty()) {
                return String.valueOf(virtualPrefix) + ethernetMAC;
            }
            ethernetMAC = this.getEthernetHardwareAddressForUsbDevice(vid, deviceSerial);
            String dhcpAddress = "";
            List hwInterfaces = this.runProcessForOutput("nmcli connection show | grep 'ethernet' | awk -F'  ' '{print $1}'");
            for (String hwInterface : hwInterfaces) {
                List macAddressResult = this.runProcessForOutput(String.format("nmcli connection show '%s' | grep '\\.mac-address:' | awk '{print $2}'", hwInterface));
                if (macAddressResult.isEmpty() || !((String)macAddressResult.get(0)).equalsIgnoreCase(ethernetMAC)) continue;
                List dhcpAddresses = this.runProcessForOutput(String.format("nmcli connection show '%s' | grep 'dhcp_server_identifier' | awk -F' = ' '{print $2}'", hwInterface));
                if (dhcpAddresses.isEmpty()) break;
                dhcpAddress = (String)dhcpAddresses.get(0);
                break;
            }
            return !dhcpAddress.isEmpty() ? String.valueOf(virtualPrefix) + dhcpAddress : dhcpAddress;
        }
        return null;
    }

    private String getEthernetHardwareAddressForUsbDevice(String vendorId, String deviceSerial) {
        String hwAddress = "";
        List vendorUsbInterfaces = this.runProcessForOutput(String.format(GREP_USB_NUMBERS_BY_VENDOR, vendorId.toLowerCase()));
        for (String usbInterface : vendorUsbInterfaces) {
            List hwAddresses;
            List usbSerialNumber = this.runProcessForOutput(String.format(DMESG_USB_DEVICE_SERIAL_NUMBER, usbInterface));
            if (usbSerialNumber.isEmpty() || !deviceSerial.equals(usbSerialNumber.get(0)) || (hwAddresses = this.runProcessForOutput(String.format(DMESG_HARDWARE_ADDRESS_REQUEST, usbInterface))).isEmpty()) continue;
            hwAddress = (String)hwAddresses.get(hwAddresses.size() - 1);
            break;
        }
        return hwAddress;
    }

    public String runFirmwareUpdate(String command) {
        return this.runFirmwareUpateProcess(command);
    }
}

