/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ConflictingSdkProjectFilesTreeViewer {
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image FILE_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private static final int SEL_ALL = 1;
    private static final int SEL_NON = 2;
    private static final int COMPARE = 3;
    private TreeViewer viewer;
    private MenuItem compareMenuItem;
    private PathMatcher matcher;
    private ResourcesComparer resourcesComparer;
    private Map<ResourceSdkDescriptor, IResource> conflictingFiles;
    private Button overrideAllCheckBox;
    private boolean isBackupFiles;
    private Collection<IPath> toSelect = new LinkedHashSet<IPath>();
    private Collection<IPath> toSelectFolder = new HashSet<IPath>();
    private Collection<IPath> toSelectAll = new HashSet<IPath>();

    public ConflictingSdkProjectFilesTreeViewer(Map<ResourceSdkDescriptor, IResource> conflictingResources, SdkDescriptor sdk, IProject project, Composite parent, PathMatcher matcher) {
        this(parent, matcher, sdk, project);
        this.setConflictedFiles(conflictingResources);
        this.setInput(conflictingResources.values(), project, true);
        this.resourcesComparer = new ResourcesComparer();
    }

    private ConflictingSdkProjectFilesTreeViewer(Composite parent, PathMatcher matcher, SdkDescriptor sdk, IProject project) {
        this.matcher = matcher;
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)WidgetFactory.text((int)74).text(NLS.bind((String)Messages.ConflictingSdkProjectFilesTreeViewer_description, (Object)project.getName(), (Object)SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)sdk, (boolean)false))).create((Widget)parent));
        this.viewer = new TreeViewer(parent, 68096);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.setContentProvider((IContentProvider)new SourcesTreeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setMenu(this.getMenu(this.viewer.getTree()));
        this.viewer.addDoubleClickListener(e -> this.resourcesComparer.doCompare());
        this.viewer.addSelectionChangedListener(e -> this.resourcesComparer.enableCompareMenuItem(e));
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ConflictingSdkProjectFilesTreeViewer.this.toSelectAll.contains(element);
            }
        });
        this.addColumns();
        this.isBackupFiles = true;
        this.createButtonsGroup(parent);
    }

    private void setInput(Collection<IResource> checked, IProject project, boolean expand) {
        this.toSelectFolder.clear();
        this.toSelect.clear();
        for (IResource resource : checked) {
            IPath resourcePath = resource.getLocation();
            if (2 == resource.getType()) {
                this.toSelectFolder.add(resourcePath);
                continue;
            }
            if (1 != resource.getType()) continue;
            IContainer parent = resource.getParent();
            do {
                this.toSelectFolder.add(parent.getLocation());
            } while ((parent = parent.getParent()) != null && !parent.equals((Object)project));
            this.toSelect.add(resourcePath);
        }
        this.toSelectAll.addAll(this.toSelectFolder);
        this.toSelectAll.addAll(this.toSelect);
        this.viewer.setInput((Object)project);
        if (expand) {
            this.viewer.expandAll();
        }
    }

    public Collection<ResourceSdkDescriptor> getResourcesForOverride() {
        ArrayList<ResourceSdkDescriptor> selectedPaths = new ArrayList<ResourceSdkDescriptor>();
        for (Map.Entry<ResourceSdkDescriptor, IResource> e : this.conflictingFiles.entrySet()) {
            IPath resourcePath;
            ResourceSdkDescriptor resource = e.getKey();
            IResource projectResource = e.getValue();
            if (projectResource == null || !this.toSelect.contains(resourcePath = projectResource.getLocation()) && !this.toSelectFolder.contains(resourcePath)) continue;
            selectedPaths.add(resource);
        }
        return selectedPaths;
    }

    private void addColumns() {
        TreeViewerColumn projectFilesColumn = new TreeViewerColumn(this.viewer, 0);
        projectFilesColumn.getColumn().setText(Messages.ConflictingSdkProjectFilesTreeViewer_project_files_column_title);
        projectFilesColumn.getColumn().setWidth(200);
        projectFilesColumn.setLabelProvider((CellLabelProvider)new ProjectFileColumnLabelProvider());
        TreeViewerColumn sdkFilesColumn = new TreeViewerColumn(this.viewer, 0);
        sdkFilesColumn.getColumn().setText(Messages.ConflictingSdkProjectFilesTreeViewer_sdk_files_column_title);
        sdkFilesColumn.getColumn().setWidth(300);
        sdkFilesColumn.setLabelProvider((CellLabelProvider)new SdkResourceColumnLabelProvider());
        TreeViewerColumn compareColumn = new TreeViewerColumn(this.viewer, 0);
        compareColumn.getColumn().setText(Messages.ConflictingSdkProjectFilesTreeViewer_compare_menu_item);
        compareColumn.getColumn().setWidth(130);
        compareColumn.setLabelProvider((CellLabelProvider)new CompareColumnLabelProvider());
        compareColumn.setEditingSupport((EditingSupport)new CompareColumnEditingSupport((ColumnViewer)this.viewer));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)compareColumn.getViewer());
        TreeViewerColumn overrideColumn = new TreeViewerColumn(this.viewer, 0);
        overrideColumn.getColumn().setText(Messages.ConflictingSdkProjectFilesTreeViewer_replace_column_title);
        overrideColumn.getColumn().setWidth(65);
        overrideColumn.setLabelProvider((CellLabelProvider)new SelectColumnLabelProvider());
        overrideColumn.setEditingSupport((EditingSupport)new SelectColumnEditingSupport((ColumnViewer)this.viewer));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)overrideColumn.getViewer());
    }

    private Menu getMenu(Tree tree) {
        Menu menu = new Menu((Control)tree);
        this.addItem(menu, Messages.ConflictingSdkProjectFilesTreeViewer_replace_all_menu_item_text, 1);
        this.addItem(menu, Messages.ConflictingSdkProjectFilesTreeViewer_replace_none_menu_item_text, 2);
        new MenuItem(menu, 2);
        this.compareMenuItem = this.addItem(menu, Messages.ConflictingSdkProjectFilesTreeViewer_compare_menu_item, 3);
        return menu;
    }

    private void switchSelection(int id) {
        switch (id) {
            case 1: {
                this.toSelect.clear();
                this.forEach(this.viewer.getTree().getItems());
                this.overrideAllCheckBox.setSelection(true);
                break;
            }
            case 2: {
                this.toSelect.clear();
                this.toSelectFolder.clear();
                this.overrideAllCheckBox.setSelection(false);
            }
        }
        this.viewer.refresh();
    }

    private void forEach(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof IPath) {
                IPath path = (IPath)data;
                if (path.toFile().isDirectory()) {
                    this.toSelectFolder.add(path);
                } else {
                    this.toSelect.add(path);
                }
            }
            this.forEach(treeItem.getItems());
            ++n2;
        }
    }

    public boolean isBackupFiles() {
        return this.isBackupFiles;
    }

    private MenuItem addItem(Menu menu, String txt, final int id) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(txt);
        menuItem.setID(id);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (3 == id) {
                    new ResourcesComparer().doCompare();
                } else {
                    ConflictingSdkProjectFilesTreeViewer.this.switchSelection(id);
                }
            }
        });
        return menuItem;
    }

    private void createButtonsGroup(Composite parent) {
        Composite buttonsGroup = (Composite)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create())).create((Widget)parent);
        this.overrideAllCheckBox = (Button)WidgetFactory.button((int)32).text(Messages.ConflictingSdkProjectFilesTreeViewer_replace_all_checkbox_text).onSelect(e -> this.switchSelection(((Button)e.getSource()).getSelection() ? 1 : 2)).create((Widget)buttonsGroup);
        this.overrideAllCheckBox.setSelection(true);
        ((Button)WidgetFactory.button((int)32).text(Messages.ConflictingSdkProjectFilesTreeViewer_backup_files_checkbox_text).onSelect(e -> {
            boolean bl = this.isBackupFiles = ((Button)e.getSource()).getSelection();
        }).create((Widget)buttonsGroup)).setSelection(true);
    }

    private void setConflictedFiles(Map<ResourceSdkDescriptor, IResource> conflictingFiles) {
        this.conflictingFiles = conflictingFiles;
    }

    private class CompareColumnEditingSupport
    extends EditingSupport {
        public CompareColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return element instanceof IPath && !((IPath)element).toFile().isDirectory();
        }

        protected CellEditor getCellEditor(Object arg0) {
            return new CheckboxCellEditor();
        }

        protected Object getValue(Object arg0) {
            ConflictingSdkProjectFilesTreeViewer.this.resourcesComparer.doCompare();
            return Boolean.TRUE;
        }

        protected void setValue(Object arg0, Object arg1) {
        }
    }

    private static class CompareColumnLabelProvider
    extends ColumnLabelProvider {
        private CompareColumnLabelProvider() {
        }

        public String getText(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            IPath path;
            if (element instanceof IPath && !(path = (IPath)element).toFile().isDirectory()) {
                return SdkUiActivator.getInstance().getImage("COMPARE_ICON");
            }
            return null;
        }

        public String getToolTipText(Object element) {
            return Messages.ConflictingSdkProjectFilesTreeViewer_compare_menu_item;
        }
    }

    private static class ProjectFileColumnLabelProvider
    extends ColumnLabelProvider {
        private ProjectFileColumnLabelProvider() {
        }

        public String getText(Object element) {
            return element instanceof IPath ? ((IPath)element).lastSegment() : super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IPath) {
                return ((IPath)element).toFile().isDirectory() ? FOLDER_IMAGE : FILE_IMAGE;
            }
            return super.getImage(element);
        }
    }

    private class ResourcesComparer {
        private ResourcesComparer() {
        }

        private void doCompare() {
            IPath path;
            TreeItem[] selected = ConflictingSdkProjectFilesTreeViewer.this.viewer.getTree().getSelection();
            if (selected.length > 0 && !(path = (IPath)selected[0].getData()).toFile().isDirectory()) {
                ConflictingSdkProjectFilesTreeViewer.this.conflictingFiles.entrySet().stream().filter(en -> path.equals((Object)((IResource)en.getValue()).getLocation())).findFirst().ifPresent(en -> this.doCompare((IFile)en.getValue(), (ResourceSdkDescriptor)en.getKey()));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void doCompare(IFile projectResource, ResourceSdkDescriptor sdkResource) {
            String sdkResourcePath = sdkResource.getPath();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    BufferedReader lbr = new BufferedReader(new InputStreamReader(projectResource.getContents(), StandardCharsets.UTF_8));
                    try {
                        try (BufferedReader rbr = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(sdkResourcePath)), StandardCharsets.UTF_8));){
                            String prjFileContents = lbr.lines().collect(Collectors.joining("\n"));
                            final CompareItem prjFileItem = new CompareItem(projectResource.getName(), prjFileContents);
                            String sdkFileContents = rbr.lines().collect(Collectors.joining("\n"));
                            final CompareItem sdkFileItem = new CompareItem(Path.fromOSString((String)sdkResourcePath).lastSegment(), sdkFileContents);
                            CompareEditorInput compareEditorInput = new CompareEditorInput(new CompareConfiguration()){

                                protected Object prepareInput(IProgressMonitor monitor) {
                                    CompareConfiguration compareConfiguration = this.getCompareConfiguration();
                                    compareConfiguration.setLeftLabel(NLS.bind((String)Messages.ConflictingSdkProjectFilesTreeViewer_comparer_prj_file_title, (Object)prjFileItem.getName()));
                                    compareConfiguration.setLeftImage(FILE_IMAGE);
                                    compareConfiguration.setRightImage(FILE_IMAGE);
                                    compareConfiguration.setRightLabel(NLS.bind((String)Messages.ConflictingSdkProjectFilesTreeViewer_comparer_sdk_file_title, (Object)sdkFileItem.getName()));
                                    compareConfiguration.setLeftEditable(false);
                                    compareConfiguration.setRightEditable(false);
                                    return new Differencer().findDifferences(false, monitor, null, null, (Object)prjFileItem, (Object)sdkFileItem);
                                }
                            };
                            Display.getDefault().syncExec(() -> CompareUI.openCompareDialog((CompareEditorInput)compareEditorInput));
                        }
                        if (lbr == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (lbr == null) throw throwable;
                        lbr.close();
                        throw throwable;
                    }
                    lbr.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                SdkUiActivator.getInstance().logError("Fail to perform resources comparision due to error", e);
            }
        }

        private void enableCompareMenuItem(SelectionChangedEvent sce) {
            IStructuredSelection selection = (IStructuredSelection)sce.getSelection();
            IPath path = (IPath)selection.getFirstElement();
            ConflictingSdkProjectFilesTreeViewer.this.compareMenuItem.setEnabled(!path.toFile().isDirectory());
        }

        private class CompareItem
        implements IStreamContentAccessor,
        ITypedElement {
            private String name;
            private String contents;

            private CompareItem(String name, String content) {
                this.name = name;
                this.contents = content;
            }

            public String getName() {
                return this.name;
            }

            public Image getImage() {
                return null;
            }

            public String getType() {
                return "txt";
            }

            public InputStream getContents() throws CoreException {
                return new ByteArrayInputStream(this.contents.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private static class ResourcesMatcher {
        private ResourcesMatcher() {
        }

        private static Collection<IPath> matchedChildren(IPath parentPath, PathMatcher pathMatcher, boolean recursive) {
            ArrayList<IPath> result = new ArrayList<IPath>();
            File asFile = parentPath.toFile();
            if (!asFile.isFile() && asFile.exists()) {
                Collection<File> files = ResourcesMatcher.filterAndSortFiles(ResourcesMatcher.listFiles(parentPath, pathMatcher, recursive));
                for (File f : files) {
                    result.add(Path.fromOSString((String)f.getAbsolutePath()));
                }
            }
            return result;
        }

        private static Collection<File> filterAndSortFiles(File[] src) {
            if (src == null || src.length == 0) {
                return Collections.emptyList();
            }
            Map<Boolean, List<File>> files = Arrays.stream(src).collect(Collectors.partitioningBy(f -> f == null || !f.exists() || !f.canRead() || f.isDirectory() && f.listFiles() == null));
            files.get(true).forEach(f -> SdkUiActivator.getInstance().logError(NLS.bind((String)"Removed {0}", (Object)f)));
            return files.get(false).stream().sorted((o1, o2) -> o1.isDirectory() ^ o2.isDirectory() ? (o1.isDirectory() ? -1 : 1) : o1.getAbsolutePath().compareTo(o2.getAbsolutePath())).collect(Collectors.toList());
        }

        private static File[] listFiles(IPath parentPath, final PathMatcher pathMatcher, final boolean recursive) {
            return parentPath.toFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (pathMatcher == null) {
                        return true;
                    }
                    boolean additional = true;
                    java.nio.file.Path path = null;
                    try {
                        path = Paths.get(file.getAbsolutePath(), new String[0]);
                    }
                    catch (InvalidPathException ipe) {
                        File parent = file.getParentFile();
                        IStatus errorStatus = SdkUiActivator.getInstance().createError(NLS.bind((String)"Matching child files of {0} error. File path is invalid: {1}. Skipped.", (Object)parent, (Object)ipe.getMessage()));
                        SdkUiActivator.getInstance().log(errorStatus);
                        return false;
                    }
                    return file.isDirectory() && recursive && this.acceptChildren(file) || path != null && (pathMatcher.matches(path.getFileName()) || pathMatcher.matches(path)) && additional;
                }

                private boolean acceptChildren(File directory) {
                    File[] files = directory.listFiles();
                    return files != null && Arrays.stream(files).anyMatch(this::accept);
                }
            });
        }
    }

    private class SdkResourceColumnLabelProvider
    extends ColumnLabelProvider {
        private SdkResourceColumnLabelProvider() {
        }

        public String getText(Object element) {
            Optional<Map.Entry> optional;
            IPath path;
            if (element instanceof IPath && !(path = (IPath)element).toFile().isDirectory() && (optional = ConflictingSdkProjectFilesTreeViewer.this.conflictingFiles.entrySet().stream().filter(e -> path.equals((Object)((IResource)e.getValue()).getLocation())).findFirst()).isPresent()) {
                return this.getSdkResourcePath((ResourceSdkDescriptor)optional.get().getKey());
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof IPath && !((IPath)element).toFile().isDirectory()) {
                return FILE_IMAGE;
            }
            return null;
        }

        private String getSdkResourcePath(ResourceSdkDescriptor sdkResource) {
            try {
                String declaredSdkBaseBath = SdkDescriptors.getSdkDescriptor((String)sdkResource.getSdkId()).getBasePath();
                String resolvedSdkBasePath = Paths.get(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(declaredSdkBaseBath), new String[0]).normalize().toString();
                return Paths.get(resolvedSdkBasePath, new String[0]).relativize(Paths.get(sdkResource.getPath(), new String[0])).toString();
            }
            catch (CoreException coreException) {
                return "";
            }
        }
    }

    private class SelectColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        private SelectColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return element instanceof IPath;
        }

        protected Boolean getValue(Object element) {
            if (element instanceof IPath) {
                IPath path = (IPath)element;
                return path.toFile().isDirectory() ? ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder.contains(path) : ConflictingSdkProjectFilesTreeViewer.this.toSelect.contains(path);
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            boolean isSelected = (Boolean)value;
            if (element instanceof IPath) {
                IPath path = (IPath)element;
                if (path.toFile().isDirectory()) {
                    this.handleDirectorySelection(path, isSelected);
                } else {
                    this.handleFileSelection(path, isSelected);
                }
            }
            this.getViewer().refresh();
            ConflictingSdkProjectFilesTreeViewer.this.overrideAllCheckBox.setSelection(this.isSelectedAll());
        }

        private void handleDirectorySelection(IPath parentPath, final boolean isSelected) {
            java.nio.file.Path startPath = Paths.get(parentPath.toOSString(), new String[0]);
            try {
                Files.walkFileTree(startPath, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes ba) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                        IPath path = Path.fromOSString((String)dir.toString());
                        Collection<IPath> toProcess = ResourcesMatcher.matchedChildren(path, ((SelectColumnEditingSupport)SelectColumnEditingSupport.this).ConflictingSdkProjectFilesTreeViewer.this.matcher, false);
                        if (isSelected && ((SelectColumnEditingSupport)SelectColumnEditingSupport.this).ConflictingSdkProjectFilesTreeViewer.this.toSelectAll.contains(path)) {
                            ((SelectColumnEditingSupport)SelectColumnEditingSupport.this).ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder.add(path);
                            ((SelectColumnEditingSupport)SelectColumnEditingSupport.this).ConflictingSdkProjectFilesTreeViewer.this.toSelect.addAll(toProcess);
                            return FileVisitResult.CONTINUE;
                        }
                        if (((SelectColumnEditingSupport)SelectColumnEditingSupport.this).ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder.contains(path)) {
                            ((SelectColumnEditingSupport)SelectColumnEditingSupport.this).ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder.remove(path);
                            ((SelectColumnEditingSupport)SelectColumnEditingSupport.this).ConflictingSdkProjectFilesTreeViewer.this.toSelect.removeAll(toProcess);
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(java.nio.file.Path path, IOException exc) throws IOException {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                });
            }
            catch (IOException ioe) {
                SdkUiActivator.getInstance().logError(NLS.bind((String)"Fail check files on path {0}", (Object)startPath), ioe);
            }
            this.handleParentSelection(parentPath, isSelected);
        }

        private void handleFileSelection(IPath path, boolean isSelected) {
            if (isSelected) {
                ConflictingSdkProjectFilesTreeViewer.this.toSelect.add(path);
            } else {
                ConflictingSdkProjectFilesTreeViewer.this.toSelect.remove(path);
            }
            this.handleParentSelection(path, isSelected);
        }

        private void handleParentSelection(IPath path, boolean isSelected) {
            File parentFile = path.toFile().getParentFile();
            IPath parentPath = Path.fromOSString((String)parentFile.getPath());
            if (isSelected && ConflictingSdkProjectFilesTreeViewer.this.toSelectAll.contains(parentPath)) {
                ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder.add(parentPath);
                this.handleParentSelection(parentPath, isSelected);
            } else {
                File[] listFiles = parentFile.listFiles(file -> {
                    IPath apath = Path.fromOSString((String)file.getPath());
                    return ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder.contains(apath) || ConflictingSdkProjectFilesTreeViewer.this.toSelect.contains(apath);
                });
                if (listFiles != null && listFiles.length == 0) {
                    ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder.remove(parentPath);
                }
            }
        }

        private boolean isSelectedAll() {
            LinkedHashSet<IPath> selectedPaths = new LinkedHashSet<IPath>();
            selectedPaths.addAll(ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder);
            selectedPaths.addAll(ConflictingSdkProjectFilesTreeViewer.this.toSelect);
            Set selectedFiles = selectedPaths.stream().filter(p -> !p.toFile().isDirectory()).collect(Collectors.toSet());
            Set conflictingFilesLocations = ConflictingSdkProjectFilesTreeViewer.this.conflictingFiles.values().stream().map(IResource::getLocation).collect(Collectors.toSet());
            return selectedFiles.containsAll(conflictingFilesLocations);
        }
    }

    private class SelectColumnLabelProvider
    extends CellLabelProvider {
        private SelectColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            boolean isCellSelected = false;
            if (element instanceof IPath) {
                IPath path = (IPath)element;
                isCellSelected = path.toFile().isDirectory() ? ConflictingSdkProjectFilesTreeViewer.this.toSelectFolder.contains(path) : ConflictingSdkProjectFilesTreeViewer.this.toSelect.contains(path);
                cell.setImage(isCellSelected ? SdkUiActivator.getInstance().getImage("SDK_COMMON_CHECK_ICON") : SdkUiActivator.getInstance().getImage("SDK_COMMON_UNCHECK_ICON"));
            } else {
                cell.setImage(null);
            }
        }

        public String getToolTipText(Object element) {
            return Messages.ConflictingSdkProjectFilesTreeViewer_replace_column_title;
        }
    }

    private class SourcesTreeContentProvider
    implements ITreeContentProvider {
        private SourcesTreeContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            if (element instanceof IPath) {
                java.nio.file.Path parent = Paths.get(((IPath)element).toOSString(), new String[0]).getParent();
                return parent != null ? Path.fromOSString((String)parent.toFile().getAbsolutePath()) : null;
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IPath) {
                return this.getMatchedChildren((IPath)parentElement).toArray(new IPath[0]);
            }
            if (parentElement instanceof IResource) {
                return this.getMatchedChildren(((IResource)parentElement).getLocation()).toArray(new IPath[0]);
            }
            return new Object[0];
        }

        private Collection<IPath> getMatchedChildren(IPath parentPath) {
            return ResourcesMatcher.matchedChildren(parentPath, ConflictingSdkProjectFilesTreeViewer.this.matcher, true);
        }
    }
}

