/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkVersion;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkKind;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SdkHeader {
    public static final String PEX_ATTRIBUTE_TAG = "pex";
    private String name;
    private SdkVersion version;
    private String versionString;
    private String id;
    private String description;
    private final boolean isPex;
    private final String cores;
    private String langs;
    private String basePath;
    private String resolvedBasePath;
    private String obsoleteToolchainIds;
    private Set<String> tags;
    private String targetFolderName;
    private String targetProjectTemplate;
    private String externalId;
    private String descriptorPath;
    private boolean isLoadedByUser;
    private String deviceRevisionId;

    public SdkHeader(SdkHeaderParameters parameters) {
        this.name = parameters.getName();
        this.setVersion(parameters.getVersion());
        this.id = SdkDescriptorUtils.makeId((String)this.name, (String)this.versionString);
        this.description = parameters.getDescription();
        this.setBasePath(parameters.getSdkPath());
        this.cores = parameters.getCores();
        this.isPex = parameters.isPex();
        this.langs = parameters.getLangs();
        this.tags = parameters.getTags();
        this.targetFolderName = parameters.getTargetFolderName();
        this.targetProjectTemplate = parameters.getTargetProjectTemplate();
        this.externalId = parameters.getExternalId();
        this.descriptorPath = parameters.getDescriptorPath();
        this.isLoadedByUser = parameters.isLoadedByUser();
    }

    public SdkHeader(boolean createVar, Element e) {
        this(e, createVar);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SdkVersion getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean isPEx() {
        return this.isPex;
    }

    public String getLangs() {
        return Objects.toString(this.langs, "");
    }

    public String getCores() {
        return this.cores;
    }

    public String getObsoleteToolchainIds() {
        if (this.obsoleteToolchainIds != null) {
            String tcIds = this.obsoleteToolchainIds.trim();
            return !tcIds.isEmpty() ? tcIds : null;
        }
        return null;
    }

    private String getTargetFolderName() {
        return Objects.toString(this.targetFolderName, "");
    }

    public String getDeviceRevisionId() {
        return this.deviceRevisionId;
    }

    private SdkHeader(Element holderElement, boolean createVar) {
        this.obsoleteToolchainIds = SdkHeader.get(holderElement, "toolchains");
        this.isPex = false;
        this.cores = SdkHeader.get(holderElement, "cores");
        this.setName(holderElement);
        this.setVersion(holderElement);
        this.id = SdkDescriptorUtils.makeId((Element)holderElement);
        this.setBasePath(holderElement);
        this.setDescription(holderElement);
        this.setLanguage(holderElement);
        this.setTags(holderElement);
        this.setTargetFolderName(holderElement);
        this.setTargetProjectTemplate(holderElement);
        this.setExternalId(holderElement);
        this.setDescriptorPath(holderElement);
        if (createVar) {
            SdkHeader.createEnv(holderElement, this.basePath);
        }
    }

    private void setBasePath(Element holderElement) {
        String basePathAttributeValue = SdkHeader.get(holderElement, "basePath");
        if (basePathAttributeValue != null && !basePathAttributeValue.isEmpty()) {
            this.setBasePath(basePathAttributeValue);
        }
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
        if (basePath != null) {
            this.resolvedBasePath = SdkManagementUtils.performStringSubstitution((String)basePath, null);
        }
    }

    private void setName(Element holderElement) {
        String nameAttributeValue = SdkHeader.get(holderElement, "name");
        if (nameAttributeValue != null) {
            this.name = nameAttributeValue;
        }
    }

    private void setVersion(Element holderElement) {
        String versionAttributeValue = SdkHeader.get(holderElement, "version");
        if (versionAttributeValue != null) {
            this.setVersion(versionAttributeValue);
        }
    }

    private void setVersion(String version) {
        try {
            this.version = SdkVersion.createVersion((String)version);
            this.versionString = this.version.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.versionString = version;
        }
    }

    private void setTags(Element holderElement) {
        String tagsAttributeValue = SdkHeader.get(holderElement, "tags");
        this.tags = tagsAttributeValue == null ? Collections.emptySet() : Arrays.stream(tagsAttributeValue.split(",")).map(String::trim).map(String::toLowerCase).filter(tag -> !tag.isEmpty()).collect(Collectors.toSet());
    }

    private void setDescription(Element holderElement) {
        String descriptionAttributeValue = SdkHeader.get(holderElement, "description");
        if (descriptionAttributeValue != null && !descriptionAttributeValue.isEmpty()) {
            this.description = descriptionAttributeValue;
        }
    }

    private void setLanguage(Element holderElement) {
        this.langs = this.isPex ? LangSdkKind.C.getLang() : SdkHeader.get(holderElement, "langs");
    }

    private void setTargetFolderName(Element holderElement) {
        this.targetFolderName = SdkHeader.get(holderElement, "targetFolderName");
    }

    private void setTargetProjectTemplate(Element holderElement) {
        String targetProjectTemplateAttributeValue = SdkHeader.get(holderElement, "targetProjectTemplate");
        if (targetProjectTemplateAttributeValue != null && !targetProjectTemplateAttributeValue.isEmpty()) {
            this.targetProjectTemplate = targetProjectTemplateAttributeValue;
        }
    }

    private void setExternalId(Element holderElement) {
        String externalIdAttributeValue = SdkHeader.get(holderElement, "externalId");
        if (externalIdAttributeValue != null && !(externalIdAttributeValue = externalIdAttributeValue.trim()).isEmpty()) {
            this.externalId = externalIdAttributeValue;
        }
    }

    private void setDescriptorPath(Element holderElement) {
        String descriptorPathAttributeValue = SdkHeader.get(holderElement, "descriptorPath");
        if (descriptorPathAttributeValue != null && !(descriptorPathAttributeValue = descriptorPathAttributeValue.trim()).isEmpty()) {
            this.descriptorPath = descriptorPathAttributeValue;
        }
    }

    private static String get(Element element, String attributeName) {
        return element.getAttribute(attributeName);
    }

    private static void createEnv(Element element, String path) {
        NodeList nl = element.getElementsByTagName("env");
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        Element e = (Element)nl.item(0);
        String envName = e.getAttribute("name");
        String envValue = e.getAttribute("value");
        boolean isSystem = Boolean.parseBoolean(e.getAttribute("isSystem"));
        path = path != null && path.trim().length() > 0 ? path : envValue;
        SdkEnvironmentUtils.createEnvironment((String)envName, (String)path, (String)envName, (boolean)isSystem, (boolean)true);
    }

    public static SdkHeaderParameters newSdkHeaderParameters() {
        return new SdkHeaderParameters();
    }

    public SdkHeaderParameters getSdkHeaderParameters() {
        SdkHeaderParameters parameters = new SdkHeaderParameters();
        parameters.setName(this.getName());
        parameters.setVersion(this.getVersion().toString());
        parameters.setDescription(this.getDescription());
        parameters.setTargetFolderName(this.getTargetFolderName());
        parameters.setTargetProjectTemplate(this.targetProjectTemplate);
        parameters.setSdkPath(this.getBasePath());
        parameters.setResolvedBasePath(this.resolvedBasePath);
        parameters.setLangs(this.getLangs());
        parameters.setCores(this.getCores());
        parameters.setPex(this.isPEx());
        parameters.setTags(this.tags);
        parameters.setDescriptorPath(this.descriptorPath);
        parameters.setLoadedByUser(this.isLoadedByUser);
        parameters.setExternalId(Objects.toString(this.externalId, ""));
        return parameters;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkHeader other = (SdkHeader)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static class SdkHeaderParameters {
        private String name;
        private String version;
        private String description;
        private String sdkPath;
        private String langs;
        private String cores;
        private boolean isInternal = false;
        private boolean isPex = false;
        private String targetFolderName;
        private String targetProjectTemplate;
        private Set<String> tags;
        private String externalId;
        private String descriptorPath;
        private boolean isLoadedByUser;
        private String resolvedBasePath;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getTargetFolderName() {
            return this.targetFolderName;
        }

        public void setTargetFolderName(String targetFolderName) {
            this.targetFolderName = targetFolderName;
        }

        public String getSdkPath() {
            return this.sdkPath;
        }

        public void setSdkPath(String sdkPath) {
            this.sdkPath = sdkPath;
        }

        public void setResolvedBasePath(String resolvedBasePath) {
            this.resolvedBasePath = resolvedBasePath;
        }

        public String getResolvedBasePath() {
            return this.resolvedBasePath;
        }

        public String getLangs() {
            return this.isPex() ? LangSdkKind.C.getLang() : this.langs;
        }

        public void setLangs(String langs) {
            this.langs = this.isPex() ? LangSdkKind.C.getLang() : langs;
        }

        public String getCores() {
            return this.cores;
        }

        public void setCores(String cores) {
            this.cores = cores;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public void setInternal(boolean isInternal) {
            this.isInternal = isInternal;
        }

        public boolean isPex() {
            return this.isPex;
        }

        public void setPex(boolean isPex) {
            this.isPex = isPex;
        }

        public String getTargetProjectTemplate() {
            return this.targetProjectTemplate;
        }

        public void setTargetProjectTemplate(String targetProjectTemplate) {
            this.targetProjectTemplate = targetProjectTemplate;
        }

        public Set<String> getTags() {
            return this.tags != null ? this.tags : Collections.emptySet();
        }

        public void setTags(Set<String> tags) {
            this.tags = tags;
        }

        public String getExternalId() {
            return this.externalId;
        }

        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public void setDescriptorPath(String descriptorPath) {
            this.descriptorPath = descriptorPath;
        }

        public String getDescriptorPath() {
            return this.descriptorPath;
        }

        public void setLoadedByUser(boolean isLoadedByUser) {
            this.isLoadedByUser = isLoadedByUser;
        }

        public boolean isLoadedByUser() {
            return this.isLoadedByUser;
        }
    }
}

