/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.SdkProjectCompatibilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ModelSdk;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

public class SdkModule {
    public static final String MODULE_ELEMENT = "module";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String SDK_ID_ATTRIBUTE = "sdkId";
    private final String id;
    private final String name;
    private String description;
    private final String sdkId;
    private boolean isRoot;
    private String holderSdkId;

    public SdkModule(String id, String name, String description, String sdkId) {
        this.id = Objects.requireNonNull(id, "Module id should not be null");
        this.name = Objects.requireNonNull(name, "Module name should not be null");
        this.description = description;
        this.sdkId = Objects.requireNonNull(sdkId, "Module SDK id should not be null");
        this.isRoot = true;
    }

    public SdkModule(String id, String name, String description, String sdkId, boolean isRoot) {
        this(id, name, description, sdkId);
        this.isRoot = isRoot;
    }

    public SdkModule(Element moduleElement) {
        this.id = moduleElement.getAttribute(ID_ATTRIBUTE);
        this.name = moduleElement.getAttribute(NAME_ATTRIBUTE);
        this.description = moduleElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        this.sdkId = moduleElement.getAttribute(SDK_ID_ATTRIBUTE);
        this.isRoot = false;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public String getSdkId() {
        return this.sdkId;
    }

    public ModelSdk getSdk() {
        return SdkDescriptorParser.getSdkByDescriptor(this.getSdkInternal());
    }

    public IPath getBasePath() {
        SdkDescriptor sdk = this.getSdkInternal();
        return sdk != null ? EnvironmentSdkCore.getResolvedSdkPath((String)sdk.getId()) : null;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sdkId == null ? 0 : this.sdkId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkModule other = (SdkModule)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.sdkId.equals(other.sdkId);
    }

    public IStatus checkToolChainCompatibility(String toolChainId) {
        if ("all_toolchains".equals(toolChainId)) {
            return Status.OK_STATUS;
        }
        SdkDescriptor sdk = this.getSdkInternal();
        if (sdk == null) {
            return SdkAttachStatuses.ERROR_SDK_MISSED;
        }
        Optional<String> optional = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)this.getId()).stream().map(ToolChainSdkDescriptor::getToolChainId).findFirst();
        if (!optional.isPresent()) {
            return Status.OK_STATUS;
        }
        return SdkProjectCompatibilityChecker.checkToolChainsCompatibility((String)optional.get(), (String)toolChainId);
    }

    public String getHolderSdkId() {
        return this.holderSdkId;
    }

    void setHolderSdkId(String holderSdkId) {
        this.holderSdkId = Objects.requireNonNull(holderSdkId);
    }

    private SdkDescriptor getSdkInternal() {
        SdkDescriptor sdk = SdkDescriptors.getSdkDescriptor((String)this.sdkId);
        if (sdk == null) {
            SdkUiActivator.getInstance().logError("Referenced SDK does not exist");
        }
        return sdk;
    }
}

