/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.info;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.info.InfoDialog;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class SdkResourceInfoDialog
extends InfoDialog {
    private ResourceSdkDescriptor sdkResource;

    public SdkResourceInfoDialog(Shell parentShell, ResourceSdkDescriptor sdkResource) {
        super(parentShell, "SDK Resource Info");
        this.sdkResource = Objects.requireNonNull(sdkResource);
    }

    @Override
    protected void createContent(Composite contents) {
        this.createBaseInformationGroup(contents);
        this.createExtendedParametersGroup(contents);
    }

    private void createBaseInformationGroup(Composite contents) {
        Group baseInformationGroup = this.createInfoGroup(contents, "Base information");
        String resourcePath = "";
        try {
            String declaredSdkBaseBath = SdkDescriptors.getSdkDescriptor((String)this.sdkResource.getSdkId()).getBasePath();
            String resolvedSdkBasePath = Paths.get(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(declaredSdkBaseBath), new String[0]).normalize().toString();
            resourcePath = this.sdkResource.getPath().replace(resolvedSdkBasePath, Paths.get(declaredSdkBaseBath, new String[0]).normalize().toString());
        }
        catch (CoreException coreException) {}
        this.createLinkInfoElement((Composite)baseInformationGroup, "Location:", resourcePath, new File(resourcePath).isDirectory());
        this.createInfoElement((Composite)baseInformationGroup, "Type:", this.sdkResource.getKind().name());
    }

    private void createExtendedParametersGroup(Composite contents) {
        Map<String, Object> extendedParameters = this.collectExtendedParameters();
        if (extendedParameters.values().stream().noneMatch(Objects::nonNull)) {
            return;
        }
        Group extendedParametersGroup = this.createInfoGroup(contents, "Extended parameters");
        for (Map.Entry<String, Object> e : extendedParameters.entrySet()) {
            String label = e.getKey();
            Object value = e.getValue();
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.isEmpty()) continue;
                this.createInfoElement((Composite)extendedParametersGroup, label, stringValue);
                continue;
            }
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                if (values.isEmpty()) continue;
                String stringValue = String.join((CharSequence)"\n", values.stream().filter(String.class::isInstance).map(val -> ((String)val).trim()).collect(Collectors.toList()));
                this.createInfoElement((Composite)extendedParametersGroup, label, stringValue);
                continue;
            }
            if (!(value instanceof Boolean) || !Boolean.TRUE.equals(value)) continue;
            this.createFlagInfoElement((Composite)extendedParametersGroup, label);
        }
    }

    private Map<String, Object> collectExtendedParameters() {
        LinkedHashMap<String, Object> extendedParameters = new LinkedHashMap<String, Object>();
        String langId = this.sdkResource.getLangId();
        extendedParameters.put("Lang:", !langId.isEmpty() ? langId.toUpperCase() : null);
        boolean isCopy = this.sdkResource.isCopy();
        extendedParameters.put("Copy to project:", isCopy ? Boolean.valueOf(isCopy) : null);
        String copyPath = this.sdkResource.getCopyToProjectPath();
        extendedParameters.put("Copy path:", !Objects.toString(copyPath, "").isEmpty() ? copyPath : null);
        String renameTo = this.sdkResource.getRenameTo();
        extendedParameters.put("Rename to:", !Objects.toString(renameTo, "").isEmpty() ? renameTo : null);
        Set relatedConfigurations = this.sdkResource.getConfigurations();
        extendedParameters.put("Configurations:", !relatedConfigurations.isEmpty() ? relatedConfigurations : null);
        boolean toOpen = this.sdkResource.isToOpen();
        extendedParameters.put("Open after attach:", toOpen ? Boolean.valueOf(toOpen) : null);
        return extendedParameters;
    }
}

