/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.property;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkTableViewerHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.info.SdkInfoDialog;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.PropertyPageButtonBar;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.PropertyPageFilterBar;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.PropertyPageSelection;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSdksPropertyPage
extends DialogPage {
    private static final String HELP_CONTEXT_ID = "com.freescale.s32ds.cross.sdk.support.SDK_MGMT_context";
    private static final int TABLE_W_HINT = 600;
    private static final int TABLE_H_HINT = 320;
    protected TableViewer viewer;
    protected PropertyPageButtonBar.PropertyPageButtons[] buttonIds;
    protected PropertyPageButtonBar buttonBar;
    protected PropertyPageFilterBar.PropertyPageFilters[] filterIds;
    protected PropertyPageFilterBar filterBar;
    protected PropertyPageSelection selection;
    private Shell shell;
    private SdkTableViewerHolder tableViewerHolder;

    public void createControl(Composite parent) {
        Composite control = this.createContents(parent);
        this.setControl((Control)control);
    }

    protected Composite createContents(Composite parent) {
        this.shell = parent.getShell();
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite pageComponent = (Composite)((CompositeFactory)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).font(font)).create((Widget)parent);
        Composite tableComposite = (Composite)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)GridDataFactory.swtDefaults().hint(600, 320).align(4, 4).grab(true, true).create())).create((Widget)pageComponent);
        this.tableViewerHolder = this.createTableViewerHolder(tableComposite);
        this.viewer = this.tableViewerHolder.getTableViewer();
        this.viewer.getTable().setFont(font);
        this.addTableListeners();
        this.setupMenu();
        this.selection = new PropertyPageSelection(this.viewer.getTable());
        this.buttonBar = new PropertyPageButtonBar(this.buttonIds, pageComponent, this);
        this.filterBar = new PropertyPageFilterBar(this.filterIds, pageComponent, this);
        this.updateControlsEnabedState();
        this.setHelpContextId(parent);
        this.updateViewerInput();
        if (this.viewer.getTable().getItemCount() > 0) {
            this.viewer.getTable().setSelection(0);
            this.viewer.getTable().setFocus();
            this.updateControlsEnabedState();
        }
        return pageComponent;
    }

    protected void setHelpContextId(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_ID);
    }

    public void saveFiltersToPreference() {
        if (this.filterBar != null) {
            this.filterBar.saveFiltersToPreferences();
        }
    }

    protected Collection<SdkDescriptor> getSDKs() {
        return this.getFilteredSdks(this.filterBar != null ? this.filterBar.getFilter() : sdk -> true);
    }

    protected abstract SdkTableViewerHolder createTableViewerHolder(Composite var1);

    protected FilterOptions getFilterOptions() {
        return null;
    }

    protected SdkType getSdkType() {
        return SdkType.WORKSPACE;
    }

    protected IProject getProject() {
        return null;
    }

    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    public void updateWidgetState() {
        Runnable update = () -> {
            Collection<String> saved = this.selection.save();
            this.updateViewerInput();
            this.selection.restore(saved);
            this.updateControlsEnabedState();
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(update);
        } else {
            update.run();
        }
    }

    protected void updateControlsEnabedState() {
        this.buttonBar.updateEnabledState();
    }

    private void addTableListeners() {
        Table table = this.viewer.getTable();
        table.addListener(13, e -> this.updateControlsEnabedState());
        table.addKeyListener(KeyListener.keyPressedAdapter(event -> {
            if (event.keyCode == 127) {
                this.buttonBar.notifyButtonListeners(PropertyPageButtonBar.PropertyPageButtons.REMOVE);
            } else if (event.keyCode == 32) {
                this.buttonBar.notifyButtonListeners(PropertyPageButtonBar.PropertyPageButtons.EDIT);
            } else if (event.keyCode == 105 && (event.stateMask & 0x40000) != 0) {
                this.showSdksInfo();
            }
        }));
    }

    private void setupMenu() {
        Table table = this.viewer.getTable();
        Menu menu = new Menu((Control)table);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(Messages.SdkPreferencesPage_menuitem_reset_columns_size);
        menuItem.addListener(13, e -> this.resetTable());
        table.setMenu(menu);
    }

    private void resetTable() {
        this.tableViewerHolder.resetTableLayout();
    }

    private void showSdksInfo() {
        this.getAllSelected().stream().findFirst().ifPresent(selectedSdk -> {
            int n = new SdkInfoDialog(this.shell, (SdkDescriptor)selectedSdk).open();
        });
    }

    protected Collection<SdkDescriptor> getAllSelected() {
        return Arrays.stream(this.viewer.getTable().getSelection()).filter(i -> i.getData() instanceof SdkDescriptor).collect(Collectors.mapping(i -> (SdkDescriptor)i.getData(), Collectors.toList()));
    }

    protected void updateViewerInput() {
        Collection<SdkDescriptor> sdks = this.getSDKs();
        this.viewer.setInput(sdks);
        this.viewer.setItemCount(sdks.size());
    }

    protected Collection<SdkDescriptor> getFilteredSdks(SdkFilter filter) {
        return SdkManagementUtils.getFilteredSdks((SdkFilter)filter).stream().filter(sdkDescriptor -> SdkType.INTERNAL != sdkDescriptor.getType()).sorted(SdkManagementUtils.getSdksComparator()).collect(Collectors.toList());
    }
}

