/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.property;

import com.nxp.s32ds.cle.cdt.sdk.core.filtering.LatestSdkVersionFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.SdkHardwareFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.AbstractSdksPropertyPage;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.ProjectSdksPropertyPage;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.CoreDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;

class PropertyPageFilterBar {
    private Map<PropertyPageFilters, AbstractPropertyPageFilter> filters;
    private AbstractSdksPropertyPage page;

    PropertyPageFilterBar(PropertyPageFilters[] filterIds, Composite parent, AbstractSdksPropertyPage page) {
        this.page = page;
        this.create(filterIds, parent);
    }

    SdkFilter getFilter() {
        AbstractPropertyPageFilter versionFilter = this.filters.get((Object)PropertyPageFilters.LATEST_VERSION);
        if (versionFilter != null && versionFilter.isEnabled()) {
            return versionFilter.getFilter();
        }
        AbstractPropertyPageFilter primaryFilter = this.filters.get((Object)PropertyPageFilters.HARDWARE_IDS);
        if (primaryFilter == null || !primaryFilter.isEnabled()) {
            primaryFilter = this.filters.get((Object)PropertyPageFilters.SHOW_ALL_SDKS);
        }
        return primaryFilter != null ? primaryFilter.getFilter() : sdk -> true;
    }

    boolean isFilterEnabled(PropertyPageFilters filterId) {
        AbstractPropertyPageFilter filter = this.filters.get((Object)filterId);
        return filter != null && filter.isEnabled();
    }

    void saveFiltersToPreferences() {
        this.filters.values().forEach(AbstractPropertyPageFilter::saveToPreferences);
    }

    private void create(PropertyPageFilters[] filterIds, Composite parent) {
        Group filterGroup = new Group(parent, 0);
        filterGroup.setText(Messages.AbstractSdksPropertyPage_filter_area_group_text);
        filterGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(filterIds.length).create());
        filterGroup.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).create());
        this.filters = new EnumMap<PropertyPageFilters, AbstractPropertyPageFilter>(PropertyPageFilters.class);
        PropertyPageFilters[] propertyPageFiltersArray = filterIds;
        int n = filterIds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyPageFilters filterId = propertyPageFiltersArray[n2];
            this.filters.put(filterId, filterId.createFilter(this, (Composite)filterGroup));
            ++n2;
        }
    }

    private static abstract class AbstractPropertyPageFilter {
        protected boolean isEnabled;

        private AbstractPropertyPageFilter() {
        }

        protected abstract SdkFilter getFilter();

        protected boolean isEnabled() {
            return this.isEnabled;
        }

        protected void saveToPreferences() {
        }
    }

    static enum PropertyPageFilters {
        SHOW_ALL_SDKS{

            @Override
            AbstractPropertyPageFilter createFilter(PropertyPageFilterBar filters, Composite parent) {
                PropertyPageFilterBar propertyPageFilterBar = filters;
                propertyPageFilterBar.getClass();
                return propertyPageFilterBar.new PropertyPageShowAllSdksFilter(parent);
            }
        }
        ,
        LATEST_VERSION{

            @Override
            AbstractPropertyPageFilter createFilter(PropertyPageFilterBar filters, Composite parent) {
                PropertyPageFilterBar propertyPageFilterBar = filters;
                propertyPageFilterBar.getClass();
                return propertyPageFilterBar.new PropertyPageLatestSdkVersionFilter(parent);
            }
        }
        ,
        HARDWARE_IDS{

            @Override
            AbstractPropertyPageFilter createFilter(PropertyPageFilterBar filters, Composite parent) {
                PropertyPageFilterBar propertyPageFilterBar = filters;
                propertyPageFilterBar.getClass();
                return propertyPageFilterBar.new PropertyPageHardwareFilter(parent);
            }
        };


        abstract AbstractPropertyPageFilter createFilter(PropertyPageFilterBar var1, Composite var2);
    }

    private class PropertyPageHardwareFilter
    extends AbstractPropertyPageFilter {
        private String deviceId;
        private ComboViewer deviceCoreCombo;
        private String deviceCoreId;
        private ComboViewer coreCombo;
        private String coreId;
        private Button resetButton;

        private PropertyPageHardwareFilter(Composite parent) {
            this.create(parent);
        }

        private Composite create(Composite parent) {
            Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(5).create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).create((Widget)parent);
            WidgetFactory.label((int)16384).text(Messages.PropertyPageFilterBar_hardware_filter_label).create((Widget)composite);
            ComboViewer deviceComboViewer = this.createHardwareComboViewer(composite, "com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
            deviceComboViewer.setInput((Object)DeviceDescriptors.getDeviceDescriptors());
            deviceComboViewer.add((Object)"");
            this.deviceCoreCombo = this.createHardwareComboViewer(composite, "com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
            this.deviceCoreCombo.setInput((Object)DeviceDescriptors.getDeviceCoreDescriptors());
            this.coreCombo = this.createHardwareComboViewer(composite, "com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
            this.coreCombo.setInput((Object)CoreDescriptors.getCoreDescriptors());
            this.resetButton = (Button)((ButtonFactory)WidgetFactory.button((int)0).text(Messages.PropertyPageFilterBar_hardware_filter_button_reset).onSelect(e -> deviceComboViewer.setSelection((ISelection)StructuredSelection.EMPTY)).enabled(false)).create((Widget)composite);
            return composite;
        }

        @Override
        protected SdkFilter getFilter() {
            if (this.deviceId != null || this.deviceCoreId != null || this.coreId != null) {
                return new SdkHardwareFilter(this.deviceId, this.deviceCoreId, this.coreId);
            }
            return sdk -> true;
        }

        private ComboViewer createHardwareComboViewer(Composite parent, String hardwareId) {
            Combo combo = new Combo(parent, 2060);
            combo.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
            ComboViewer comboViewer = new ComboViewer(combo);
            comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof EntityDescriptor) {
                        return ((EntityDescriptor)element).getId();
                    }
                    if (element instanceof String) {
                        return (String)element;
                    }
                    return "";
                }
            });
            comboViewer.getCombo().addListener(36, event -> {
                comboViewer.setInput(event.data);
                comboViewer.refresh();
                comboViewer.add((Object)"");
            });
            comboViewer.addSelectionChangedListener(this.getSelectionChangedListener(hardwareId));
            comboViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object element1, Object element2) {
                    String device1Id = element1 instanceof EntityDescriptor ? ((EntityDescriptor)element1).getId() : (String)element1;
                    String device2Id = element2 instanceof EntityDescriptor ? ((EntityDescriptor)element2).getId() : (String)element2;
                    return device1Id.compareTo(device2Id);
                }
            });
            comboViewer.add((Object)"");
            return comboViewer;
        }

        private ISelectionChangedListener getSelectionChangedListener(final String hardwareId) {
            return new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    switch (hardwareId) {
                        case "com.nxp.s32ds.cle.runtime.hardware.registry.device.id": {
                            this.selectDeviceId(selection);
                            break;
                        }
                        case "com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id": {
                            this.selectDeviceCoreId(selection);
                            break;
                        }
                        case "com.nxp.s32ds.cle.runtime.hardware.registry.core.id": {
                            this.selectCoreId(selection);
                        }
                    }
                    PropertyPageHardwareFilter.this.resetButton.setEnabled(PropertyPageHardwareFilter.this.isEnabled());
                    ((PropertyPageHardwareFilter)PropertyPageHardwareFilter.this).PropertyPageFilterBar.this.page.updateWidgetState();
                }

                private void selectDeviceId(IStructuredSelection selection) {
                    EntityDescriptor selectedDevice = this.getSelectedEntity(selection);
                    if (selectedDevice != null) {
                        PropertyPageHardwareFilter.this.deviceId = selectedDevice.getId();
                        this.updateComboViewer(PropertyPageHardwareFilter.this.deviceCoreCombo, DeviceDescriptors.getDeviceCoreDescriptors((String)PropertyPageHardwareFilter.this.deviceId));
                        this.updateComboViewer(PropertyPageHardwareFilter.this.coreCombo, DeviceDescriptors.getCoreDescriptors((String)PropertyPageHardwareFilter.this.deviceId));
                    } else {
                        PropertyPageHardwareFilter.this.deviceId = null;
                        this.updateComboViewer(PropertyPageHardwareFilter.this.deviceCoreCombo, DeviceDescriptors.getDeviceCoreDescriptors());
                        this.updateComboViewer(PropertyPageHardwareFilter.this.coreCombo, CoreDescriptors.getCoreDescriptors());
                    }
                    PropertyPageHardwareFilter.this.deviceCoreId = null;
                    PropertyPageHardwareFilter.this.coreId = null;
                }

                private void selectDeviceCoreId(IStructuredSelection selection) {
                    EntityDescriptor selectedDeviceCore = this.getSelectedEntity(selection);
                    if (selectedDeviceCore != null) {
                        PropertyPageHardwareFilter.this.deviceCoreId = selectedDeviceCore.getId();
                        String xcoreId = ((DeviceCoreDescriptor)selectedDeviceCore).getCoreId();
                        this.updateComboViewer(PropertyPageHardwareFilter.this.coreCombo, Collections.singletonList(CoreDescriptors.getCoreDescriptor((String)xcoreId)));
                    } else {
                        PropertyPageHardwareFilter.this.deviceCoreId = null;
                        this.updateComboViewer(PropertyPageHardwareFilter.this.coreCombo, CoreDescriptors.getCoreDescriptors());
                    }
                    PropertyPageHardwareFilter.this.coreId = null;
                }

                private void selectCoreId(IStructuredSelection selection) {
                    EntityDescriptor selectedCore = this.getSelectedEntity(selection);
                    PropertyPageHardwareFilter.this.coreId = selectedCore != null ? selectedCore.getId() : null;
                }

                private EntityDescriptor getSelectedEntity(IStructuredSelection selection) {
                    Object selectedElement = selection.getFirstElement();
                    return selectedElement instanceof EntityDescriptor ? (EntityDescriptor)selectedElement : null;
                }

                private void updateComboViewer(ComboViewer comboViewer, Object input) {
                    Event event = new Event();
                    event.data = input;
                    event.doit = true;
                    comboViewer.getCombo().notifyListeners(36, event);
                }
            };
        }

        @Override
        protected boolean isEnabled() {
            return this.deviceId != null || this.deviceCoreId != null || this.coreId != null;
        }
    }

    private class PropertyPageLatestSdkVersionFilter
    extends AbstractPropertyPageFilter {
        private static final String FILTER_SDKS_PREF_KEY = "FILTER_SDKs_SHOW_LATEST_VERSIONS";

        private PropertyPageLatestSdkVersionFilter(Composite parent) {
            this.isEnabled = this.getPreferences().getBoolean(FILTER_SDKS_PREF_KEY, false);
            this.create(parent);
        }

        private void create(Composite parent) {
            final Button showLatestSdkVersionCheckbox = new Button(parent, 32);
            showLatestSdkVersionCheckbox.setText(Messages.PropertyPageFilterBar_latest_sdk_versions_filter_checkbox);
            showLatestSdkVersionCheckbox.setSelection(this.isEnabled);
            showLatestSdkVersionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyPageLatestSdkVersionFilter.this.isEnabled = showLatestSdkVersionCheckbox.getSelection();
                    ((PropertyPageLatestSdkVersionFilter)PropertyPageLatestSdkVersionFilter.this).PropertyPageFilterBar.this.page.updateWidgetState();
                }
            });
        }

        @Override
        protected SdkFilter getFilter() {
            if (this.isEnabled) {
                AbstractPropertyPageFilter baseFilter = PropertyPageFilterBar.this.filters.get((Object)PropertyPageFilters.HARDWARE_IDS);
                if (baseFilter == null) {
                    baseFilter = PropertyPageFilterBar.this.filters.get((Object)PropertyPageFilters.SHOW_ALL_SDKS);
                }
                if (baseFilter != null) {
                    return new LatestSdkVersionFilter(baseFilter.getFilter());
                }
                return new LatestSdkVersionFilter();
            }
            return sdk -> true;
        }

        @Override
        protected void saveToPreferences() {
            try {
                IEclipsePreferences prefs = this.getPreferences();
                prefs.putBoolean(FILTER_SDKS_PREF_KEY, this.isEnabled);
                prefs.flush();
            }
            catch (BackingStoreException bse) {
                SdkCoreActivator.getInstance().logError(bse.getMessage());
            }
        }

        private IEclipsePreferences getPreferences() {
            return PropertyPageFilterBar.this.page instanceof ProjectSdksPropertyPage ? new ProjectScope(PropertyPageFilterBar.this.page.getProject()).getNode("com.nxp.s32ds.cle.runtime.sdk") : ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk");
        }
    }

    private class PropertyPageShowAllSdksFilter
    extends AbstractPropertyPageFilter {
        private PropertyPageShowAllSdksFilter(Composite parent) {
            this.create(parent);
        }

        private void create(Composite parent) {
            Button showAllSdksCheckbox = new Button(parent, 32);
            showAllSdksCheckbox.setText(Messages.PropertyPageFilterBar_show_all_sdks_checkbox);
            showAllSdksCheckbox.setSelection(false);
            showAllSdksCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyPageShowAllSdksFilter.this.isEnabled = ((Button)e.getSource()).getSelection();
                    ((PropertyPageShowAllSdksFilter)PropertyPageShowAllSdksFilter.this).PropertyPageFilterBar.this.page.updateWidgetState();
                }
            });
        }

        @Override
        protected SdkFilter getFilter() {
            return this.isEnabled ? new ProjectCompatibleSdksFilter(PropertyPageFilterBar.this.page.getProject()){

                public boolean accept(SdkDescriptor sdk) {
                    return true;
                }

                public FilterOptions options() {
                    return null;
                }
            } : new ProjectCompatibleSdksFilter(PropertyPageFilterBar.this.page.getProject());
        }
    }
}

