/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkDescriptor;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ShowAttachedSdksDialog
extends TitleAreaDialog {
    private static final int NAME_WIDTH = 150;
    private static final int CFGS_WIDTH = 350;
    private static final int DEFAULT_TABLE_HEIGHT = 150;
    private static final String CONFIGS_DELIMITER = " | ";
    private static final String CONTEXT_HELP_ID = "com.freescale.s32ds.cross.sdk.support.SDK_SHOW_ATTACHED_context";
    private List<SdkDescriptor> sdkList;
    private SdkDescriptor selectedSdk;
    private ComboViewer comboViewer;
    private Label projectListLabel;
    private Table table;

    public ShowAttachedSdksDialog(Shell parentShell, SdkDescriptor selectedSdk) {
        super(parentShell);
        this.selectedSdk = selectedSdk;
        this.loadSDKList();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.ShowAttachedSdksDialog_title);
        this.setMessage(Messages.ShowAttachedSdksDialog_message_default);
        Composite body = new Composite(content, 0);
        body.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().applyTo((Control)body);
        this.setupCombo(body);
        this.setupTable(body);
        if (this.selectedSdk != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedSdk));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)content, CONTEXT_HELP_ID);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ShowAttachedSdksDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private void setupCombo(Composite body) {
        new Label(body, 16384).setText(Messages.ShowAttachedSdksDialog_label_selected_sdk);
        Combo combo = new Combo(body, 2060);
        this.comboViewer = new ComboViewer(combo);
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SdkDescriptor) {
                    return SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)((SdkDescriptor)element), (boolean)false);
                }
                return "";
            }
        });
        this.comboViewer.addSelectionChangedListener(event -> {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof SdkDescriptor) {
                this.selectedSdk = (SdkDescriptor)element;
                this.projectListLabel.setText(NLS.bind((String)Messages.ShowAttachedSdksDialog_label_project_list, (Object)SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)this.selectedSdk, (boolean)false)));
            }
            this.update();
        });
        this.comboViewer.setInput(this.sdkList);
        this.comboViewer.refresh();
    }

    private void loadSDKList() {
        this.sdkList = SdkManagementUtils.getFilteredSdks(sdk -> true).stream().filter(ShowAttachedSdksDialog::isSdkVisible).sorted(SdkManagementUtils.getSdksComparator()).collect(Collectors.toList());
    }

    private static boolean isSdkVisible(SdkDescriptor sdkDescriptor) {
        if (sdkDescriptor != null) {
            switch (sdkDescriptor.getType()) {
                case INTERNAL: {
                    return false;
                }
                case PROJECT_LOCAL: {
                    ProjectSdkDescriptor projectLocalSdk = ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)sdkDescriptor.getId());
                    if (projectLocalSdk != null) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectLocalSdk.getProjectName());
                        return project != null && project.isAccessible();
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void setColumn(String title, int width) {
        TableColumn tableColumn = new TableColumn(this.table, 16388);
        tableColumn.setText(title);
        tableColumn.setWidth(width);
    }

    private void setupTable(Composite body) {
        this.projectListLabel = (Label)((LabelFactory)WidgetFactory.label((int)16384).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).span(2, 1).create())).create((Widget)body);
        this.table = new Table(body, 67588);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).hint(-1, 150).minSize(-1, 150).grab(true, false).applyTo((Control)this.table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.setColumn(Messages.ShowAttachedSdksDialog_project, 150);
        this.setColumn(Messages.ShowAttachedSdksDialog_config, 350);
        this.update();
    }

    private void update() {
        this.table.removeAll();
        if (this.selectedSdk == null) {
            return;
        }
        String selectedSdkId = this.selectedSdk.getId();
        TreeSet<IProject> projects = new TreeSet<IProject>(ShowAttachedSdksDialog.getProjectsComparator());
        projects.addAll(SdkAttachDataHolder.getProjectsSdkAttachedTo((SdkDescriptor)this.selectedSdk));
        for (IProject project : projects) {
            Collection configNames = SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo((IProject)project, (String)selectedSdkId).stream().map(IBuildObject::getName).collect(Collectors.toList());
            if (configNames.isEmpty()) continue;
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, project.getName());
            tableItem.setText(1, String.join((CharSequence)CONFIGS_DELIMITER, configNames));
        }
    }

    private static Comparator<IProject> getProjectsComparator() {
        return (project1, project2) -> {
            if (project1 == null && project2 == null) {
                return 0;
            }
            if (project1 == null) {
                return -1;
            }
            if (project2 == null) {
                return 1;
            }
            return project1.getName().compareToIgnoreCase(project2.getName());
        };
    }
}

