/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard;

import com.nxp.s32ds.cle.cdt.sdk.core.imports.SdksImporter;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkArchiveValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard.SdkCheckBoxTableComposite;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ExternalSdkWizardImportFromZipFilePage
extends WizardPage {
    static final String PAGE_ID = "com.nxp.s32ds.cle.cdt.sdk.ui.external.sdk.wizard.import.zip.page";
    private static final String DEFAULT_DESTINATION_LOCATION = System.getProperty("user.home");
    private static final String DS_PREFIX = "s32ds_";
    private static String TEMP_FILE_LOCATION = String.valueOf(ExternalSdkWizardImportFromZipFilePage.getTempFolder()) + "s32ds_" + System.currentTimeMillis() + "_sdk";
    private Text destinationField;
    private String archiveFilePath;
    private String extractionFolderPath;
    private SdkCheckBoxTableComposite tableComposite;
    private ProgressBar progressBar;
    private IValidator<String> sdkArchiveValidator = new SdkArchiveValidator();
    private boolean userSelectedExtractionFolder;
    private final Job loadJob = new LoadJob(Messages.ImportSdkDialog_load_job_name);

    public ExternalSdkWizardImportFromZipFilePage() {
        super(PAGE_ID);
        this.loadJob.setPriority(20);
    }

    private static String getTempFolder() {
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (!tmpdir.endsWith("/") && !tmpdir.endsWith("\\")) {
            tmpdir = String.valueOf(tmpdir) + File.separator;
        }
        return tmpdir;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create())).create((Widget)parent);
        this.createSelectOriginFileComposite(composite);
        this.createSdksListComposite(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.freescale.s32ds.cross.sdk.support.SDK_import_zip");
        this.createProgressBar(composite);
        this.setControl((Control)composite);
    }

    private void createProgressBar(Composite parent) {
        this.progressBar = new ProgressBar(parent, 258);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.progressBar.setVisible(false);
        this.loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult().isOK()) {
                            (this).ExternalSdkWizardImportFromZipFilePage.this.progressBar.setVisible(false);
                        }
                    }
                });
            }
        });
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.freescale.s32ds.cross.sdk.support.SDK_import_zip");
        super.performHelp();
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public String getDescription() {
        return Messages.ExternalSdkWizardImportSdkFromZipFilePage_description;
    }

    public String getTitle() {
        return Messages.ExternalSdkWizardImportSdkFromZipFilePage_title;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPage("com.nxp.s32ds.cle.cdt.sdk.ui.external.sdk.wizard.select.origin.page");
    }

    public boolean isPageComplete() {
        this.tableComposite.validate();
        return !Objects.toString(this.archiveFilePath, "").isEmpty() && !Objects.toString(this.extractionFolderPath, "").isEmpty() && this.tableComposite.hasSelectedSdks();
    }

    protected String getArchiveFilePath() {
        return this.archiveFilePath;
    }

    protected String getArchiveExtractionFolder() {
        return this.extractionFolderPath;
    }

    protected Map<String, Map<String, String>> getImportingSdks() {
        return this.tableComposite.getSelectedSdks();
    }

    private void createSelectOriginFileComposite(Composite parent) {
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).create((Widget)parent);
        ((LabelFactory)WidgetFactory.label((int)16384).text(Messages.ExternalSdkWizardImportSdkFromZipFilePage_archive_file).layoutData((Object)GridDataFactory.swtDefaults().align(16384, 0x1000000).create())).create((Widget)composite);
        Text sourceField = (Text)((TextFactory)WidgetFactory.text((int)2060).layoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create())).create((Widget)composite);
        Button browseArchiveButton = (Button)((ButtonFactory)WidgetFactory.button((int)8).text(Messages.SdkDialog_browse_button_text).layoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create())).onSelect(e -> this.selectArchiveFile(sourceField)).create((Widget)composite);
        this.setButtonLayoutData(browseArchiveButton);
        ((LabelFactory)WidgetFactory.label((int)16384).text(Messages.ExternalSdkWizardImportSdkFromZipFilePage_extration_folder).layoutData((Object)GridDataFactory.swtDefaults().align(16384, 0x1000000).create())).create((Widget)composite);
        this.destinationField = (Text)((TextFactory)WidgetFactory.text((int)2060).text(DEFAULT_DESTINATION_LOCATION).layoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create())).create((Widget)composite);
        this.extractionFolderPath = DEFAULT_DESTINATION_LOCATION;
        Button browseFolderButton = (Button)((ButtonFactory)WidgetFactory.button((int)8).text(Messages.SdkDialog_browse_button_text).layoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create())).onSelect(e -> this.selectExtractionFolder(this.destinationField)).create((Widget)composite);
        this.setButtonLayoutData(browseFolderButton);
    }

    private void createSdksListComposite(Composite parent) {
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create())).create((Widget)parent);
        ((LabelFactory)WidgetFactory.label((int)16384).text(Messages.ExternalSdkWizardImportSdkFromZipFilePage_label_sdk_list).layoutData((Object)GridDataFactory.swtDefaults().align(16384, 0x1000000).create())).create((Widget)composite);
        this.tableComposite = new SdkCheckBoxTableComposite(composite, (IWizardPage)this);
        this.tableComposite.addSelectionChangeListener(status -> this.setErrorMessage(status != null && !status.isOK() ? status.getMessage() : null));
        this.tableComposite.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                String attributeId = event.text;
                if ("basePath".equals(attributeId)) {
                    ExternalSdkWizardImportFromZipFilePage.this.extractionFolderPath = ExternalSdkWizardImportFromZipFilePage.this.tableComposite.getBasePath();
                    ExternalSdkWizardImportFromZipFilePage.this.destinationField.setText(ExternalSdkWizardImportFromZipFilePage.this.extractionFolderPath);
                }
            }
        });
    }

    private void selectArchiveFile(Text sourceField) {
        this.setErrorMessage(null);
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        dialog.setText(Messages.ImportSdkDialog_archive_selection_dialog_title);
        dialog.setFilterExtensions(new String[]{"*.zip"});
        String location = dialog.open();
        if (location != null) {
            IStatus status = this.sdkArchiveValidator.validate((Object)location);
            if (!status.isOK()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportSdkDialog_archive_selection_dialog_title, (String)status.getMessage());
            } else {
                sourceField.setText(location);
                this.archiveFilePath = location;
                String fileName = Paths.get(this.archiveFilePath, new String[0]).getFileName().toString();
                if (!this.userSelectedExtractionFolder) {
                    this.extractionFolderPath = Paths.get(DEFAULT_DESTINATION_LOCATION, fileName.substring(0, fileName.lastIndexOf(46))).toString();
                    this.destinationField.setText(this.extractionFolderPath);
                }
                this.tableComposite.setInput(Collections.emptyList());
                this.initSdkList();
            }
        }
        this.getContainer().updateButtons();
    }

    private void selectExtractionFolder(Text destinationField) {
        this.setErrorMessage(null);
        DirectoryDialog dialog = new DirectoryDialog(this.getWizard().getContainer().getShell(), 0x10002000);
        dialog.setText(Messages.SdkDialog_folder_selection_dialog_title);
        dialog.setMessage(Messages.SdkDialog_folder_selection_dialog_message);
        String location = dialog.open();
        if (location != null && new SdksImporter().isValidDestinationPath(location)) {
            destinationField.setText(location);
            this.extractionFolderPath = location;
            this.tableComposite.setDefaultBasePath(this.extractionFolderPath);
            this.userSelectedExtractionFolder = true;
        }
        this.getContainer().updateButtons();
    }

    private void initSdkList() {
        this.progressBar.setVisible(true);
        this.loadJob.schedule();
    }

    public void dispose() {
        this.loadJob.cancel();
        this.progressBar.dispose();
        super.dispose();
    }

    private class LoadJob
    extends Job {
        public LoadJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Display.getDefault().syncExec(() -> ExternalSdkWizardImportFromZipFilePage.this.tableComposite.setDefaultBasePath(ExternalSdkWizardImportFromZipFilePage.this.extractionFolderPath));
            Collection sdkList = new SdksImporter().loadSdkHeaders(ExternalSdkWizardImportFromZipFilePage.this.archiveFilePath, TEMP_FILE_LOCATION).values();
            SdkManagementUtils.deleteFolder((File)new File(TEMP_FILE_LOCATION));
            if (!monitor.isCanceled()) {
                Display.getDefault().syncExec(() -> ExternalSdkWizardImportFromZipFilePage.this.tableComposite.setInput(sdkList));
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }
}

