/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkVersionValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class SdkCheckBoxTableComposite
extends Composite {
    private static final int TABLE_MAX_VISIBLE_ROWS_NUMBER = 8;
    private CheckboxTableViewer tableViewer;
    private IValidator<String> nameValidator = new SdkNameValidator();
    private IValidator<String> versionValidator = new SdkVersionValidator();
    private IValidator<String> environmentValidator = new SdkEnvironmentNameValidator();
    private IWizardPage holderPage;
    private String defaultBasePath;

    public SdkCheckBoxTableComposite(Composite parent, IWizardPage holderPage) {
        super(parent, 0);
        this.holderPage = holderPage;
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)67588);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)SdkCheckBoxTableComposite.getContentProvider());
        this.tableViewer.addCheckStateListener(this.getCheckStateListener(holderPage));
        this.tableViewer.setComparator(SdkCheckBoxTableComposite.getViewerComparator());
        this.setLayoutData(GridDataFactory.swtDefaults().align(4, 4).grab(true, false).hint(700, 8 * this.tableViewer.getTable().getItemHeight()).create());
        TableViewerColumn nameColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        nameColumn.getColumn().setText(Messages.SdkTableViewerHolder_name_column_text);
        nameColumn.setLabelProvider(SdkCheckBoxTableComposite.getNameCellLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)nameColumn.getViewer());
        TableViewerColumn versionColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        versionColumn.getColumn().setText(Messages.SdkTableViewerHolder_version_column_text);
        versionColumn.setLabelProvider(SdkCheckBoxTableComposite.getVersionCellLabelProvider());
        TableViewerColumn basePathSelectionColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        basePathSelectionColumn.getColumn().setText(Messages.SdkTableViewerHolder_base_path_origin_column_text);
        basePathSelectionColumn.setLabelProvider(SdkCheckBoxTableComposite.getBasePathOriginCellLabelProvider());
        TableViewerColumn basePathColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        basePathColumn.getColumn().setText(Messages.SdkTableViewerHolder_base_path_column_text);
        basePathColumn.setLabelProvider(this.getBasePathCellLabelProvider());
        nameColumn.setEditingSupport(this.getCellEditingSupport(nameColumn, "name"));
        versionColumn.setEditingSupport(this.getCellEditingSupport(versionColumn, "version"));
        basePathSelectionColumn.setEditingSupport(this.getBasePathOriginCellEditingSupport());
        TableColumnLayout tableLayout = new TableColumnLayout();
        this.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(150));
        tableLayout.setColumnData((Widget)versionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        tableLayout.setColumnData((Widget)basePathSelectionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(150));
        tableLayout.setColumnData((Widget)basePathColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(250));
        CellNavigationSupport.create((TableViewer)this.tableViewer);
    }

    protected void setInput(Collection<SdkDescriptor> sdkList) {
        this.tableViewer.setInput(sdkList.stream().map(sdkDescriptor -> new SdkAttributes((SdkDescriptor)sdkDescriptor)).collect(Collectors.toList()));
        this.tableViewer.setAllChecked(true);
        this.validate();
        this.holderPage.getWizard().getContainer().updateButtons();
    }

    protected void updateSelectedTableItem(String attributeId, String attributeValue) {
        Object obj = this.getFirstSelectedElement();
        if (obj instanceof SdkAttributes) {
            SdkAttributes sdkAttributes = (SdkAttributes)obj;
            sdkAttributes.setAttribute(attributeId, attributeValue);
            this.validate();
            this.tableViewer.update((Object)sdkAttributes, null);
        }
    }

    protected String getBasePath() {
        Object obj = this.getFirstSelectedElement();
        String basePath = "";
        if (obj instanceof SdkAttributes) {
            SdkAttributes sdkAttributes = (SdkAttributes)obj;
            basePath = sdkAttributes.getBasePathOrigin() == BasePathOrigin.SDK ? sdkAttributes.getAttribute("basePath") : this.defaultBasePath;
        }
        return basePath;
    }

    protected Map<String, Map<String, String>> getSelectedSdks() {
        return Arrays.stream(this.tableViewer.getCheckedElements()).filter(SdkAttributes.class::isInstance).map(SdkAttributes.class::cast).collect(Collectors.toMap(SdkAttributes::access$0, SdkAttributes::access$1));
    }

    protected boolean hasSelectedSdks() {
        return this.tableViewer.getCheckedElements().length > 0;
    }

    protected void addSelectionChangeListener(Consumer<IStatus> consumer) {
        this.tableViewer.addSelectionChangedListener(event -> {
            IStructuredSelection ss = (IStructuredSelection)event.getSelection();
            SdkAttributes selectedItem = (SdkAttributes)ss.getFirstElement();
            consumer.accept(selectedItem != null ? selectedItem.getStatus() : null);
        });
    }

    protected void setDefaultBasePath(String defaultBasePath) {
        this.defaultBasePath = defaultBasePath;
        this.tableViewer.refresh();
    }

    private Object getFirstSelectedElement() {
        IStructuredSelection selection = this.tableViewer.getStructuredSelection();
        if (selection == null) {
            return null;
        }
        Object obj = selection.getFirstElement();
        return obj;
    }

    public IStatus validate() {
        MultiStatus validationStatus = SdkUiActivator.getInstance().createMultiStatus();
        if (this.tableViewer == null || this.tableViewer.getInput() == null) {
            return validationStatus;
        }
        ((Collection)this.tableViewer.getInput()).stream().filter(SdkAttributes.class::isInstance).map(SdkAttributes.class::cast).forEach(attributes -> {
            IStatus status = attributes.validate();
            validationStatus.add(status);
            if (!status.isOK()) {
                this.tableViewer.setChecked(attributes, false);
            }
        });
        return validationStatus;
    }

    private static IStructuredContentProvider getContentProvider() {
        return inputElement -> inputElement instanceof Collection ? ((Collection)inputElement).toArray() : Collections.emptyList().toArray();
    }

    private static ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof SdkAttributes && e2 instanceof SdkAttributes) {
                    SdkAttributes sdk1 = (SdkAttributes)e1;
                    String sdk1Name = sdk1.getAttribute("name");
                    String sdk1Version = sdk1.getAttribute("version");
                    SdkAttributes sdk2 = (SdkAttributes)e2;
                    String sdk2Name = sdk2.getAttribute("name");
                    String sdk2Version = sdk2.getAttribute("version");
                    return sdk1Name.equals(sdk2Name) ? sdk1Version.compareTo(sdk2Version) : sdk1Name.compareTo(sdk2Name);
                }
                return 0;
            }
        };
    }

    private ICheckStateListener getCheckStateListener(IWizardPage holderPage) {
        return event -> {
            Object element = event.getElement();
            if (element instanceof SdkAttributes) {
                if (event.getChecked() && !((SdkAttributes)element).validate().isOK()) {
                    this.tableViewer.setChecked(element, false);
                }
                holderPage.getWizard().getContainer().updateButtons();
            }
        };
    }

    private static CellLabelProvider getNameCellLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkAttributes) {
                    SdkAttributes attributes = (SdkAttributes)element;
                    cell.setText(attributes.getAttribute("name"));
                    attributes.updateEnvName();
                    cell.setImage(this.getImage(attributes));
                }
            }

            public String getToolTipText(Object element) {
                if (element instanceof SdkAttributes) {
                    SdkAttributes attributes = (SdkAttributes)element;
                    IStatus validationStatus = attributes.validate();
                    return !validationStatus.isOK() ? validationStatus.getMessage() : null;
                }
                return null;
            }

            private Image getImage(SdkAttributes attributes) {
                return !attributes.validate().isOK() ? SdkUiActivator.getInstance().getImage("SDK_COMMON_ERROR_ICON") : null;
            }
        };
    }

    private static CellLabelProvider getVersionCellLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkAttributes) {
                    SdkAttributes attributes = (SdkAttributes)element;
                    cell.setText(attributes.getAttribute("version"));
                    attributes.updateEnvName();
                }
            }
        };
    }

    private static CellLabelProvider getBasePathOriginCellLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkAttributes) {
                    cell.setText(((SdkAttributes)element).getBasePathOrigin().getText());
                }
            }
        };
    }

    private CellLabelProvider getBasePathCellLabelProvider() {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkAttributes) {
                    SdkAttributes attributes = (SdkAttributes)element;
                    cell.setText(BasePathOrigin.SDK == attributes.getBasePathOrigin() ? attributes.getAttribute("basePath") : SdkCheckBoxTableComposite.this.defaultBasePath);
                }
            }
        };
    }

    private EditingSupport getCellEditingSupport(TableViewerColumn column, final String attributeId) {
        return new EditingSupport(column.getViewer()){

            protected void setValue(Object element, Object value) {
                if (element instanceof SdkAttributes) {
                    ((SdkAttributes)element).setAttribute(attributeId, (String)value);
                    SdkCheckBoxTableComposite.this.holderPage.getWizard().getContainer().updateButtons();
                    SdkCheckBoxTableComposite.this.tableViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof SdkAttributes) {
                    return ((SdkAttributes)element).getAttribute(attributeId);
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                TextCellEditor textEditor = new TextCellEditor((Composite)SdkCheckBoxTableComposite.this.tableViewer.getTable());
                Text text = (Text)textEditor.getControl();
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        Text source = (Text)event.getSource();
                        SdkCheckBoxTableComposite.this.updateSelectedTableItem(attributeId, source.getText());
                        (this).SdkCheckBoxTableComposite.this.holderPage.getWizard().getContainer().updateButtons();
                    }
                });
                return textEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        };
    }

    private EditingSupport getBasePathOriginCellEditingSupport() {
        return new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof SdkAttributes) {
                    ((SdkAttributes)element).setBasePathOrigin((BasePathOrigin)((Object)value));
                    SdkCheckBoxTableComposite.this.tableViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof SdkAttributes) {
                    return ((SdkAttributes)element).getBasePathOrigin();
                }
                return BasePathOrigin.DEFAULT;
            }

            protected CellEditor getCellEditor(Object element) {
                ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)SdkCheckBoxTableComposite.this.tableViewer.getTable(), 12);
                cellEditor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return element instanceof BasePathOrigin ? ((BasePathOrigin)((Object)element)).getText() : "";
                    }
                });
                cellEditor.setInput((Object)BasePathOrigin.values());
                CCombo combo = (CCombo)cellEditor.getControl();
                combo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        CCombo source = (CCombo)event.getSource();
                        Object obj = SdkCheckBoxTableComposite.this.getFirstSelectedElement();
                        if (obj instanceof SdkAttributes) {
                            SdkAttributes attributes = (SdkAttributes)obj;
                            attributes.setBasePathOrigin(BasePathOrigin.DEFAULT.text.equals(source.getText()) ? BasePathOrigin.DEFAULT : BasePathOrigin.SDK);
                            SdkCheckBoxTableComposite.this.validate();
                            (this).SdkCheckBoxTableComposite.this.holderPage.getWizard().getContainer().updateButtons();
                            (this).SdkCheckBoxTableComposite.this.tableViewer.update((Object)attributes, null);
                        }
                    }
                });
                return cellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        };
    }

    private static enum BasePathOrigin {
        DEFAULT(Messages.ImportSdkPathResolveDialog_label_destination_default_path),
        SDK(Messages.ImportSdkPathResolveDialog_label_destination_sdk_base_path);

        private String text;

        private BasePathOrigin(String text) {
            this.text = text;
        }

        private String getText() {
            return this.text;
        }
    }

    private static class CellNavigationSupport {
        private CellNavigationSupport() {
        }

        private static void create(TableViewer tableViewer) {
            TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)tableViewer), CellNavigationSupport.getNavigationStrategy(tableViewer));
            int feature = 58;
            TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)CellNavigationSupport.getActivationStrategy(tableViewer), (int)feature);
        }

        private static ColumnViewerEditorActivationStrategy getActivationStrategy(TableViewer tableViewer) {
            return new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

                protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                    return event.eventType == 5 || event.eventType == 2;
                }
            };
        }

        private static CellNavigationStrategy getNavigationStrategy(final TableViewer tableViewer) {
            return new CellNavigationStrategy(){

                public ViewerCell findSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                    ViewerCell cell = super.findSelectedCell(viewer, currentSelectedCell, event);
                    if (cell != null) {
                        tableViewer.getTable().showColumn(tableViewer.getTable().getColumn(cell.getColumnIndex()));
                    }
                    return cell;
                }
            };
        }
    }

    class SdkAttributes {
        private String sdkId;
        private Map<String, String> attributes;
        private IStatus status;
        private String envName;
        private BasePathOrigin basePathOrigin;

        private SdkAttributes(SdkDescriptor sdk) {
            this.sdkId = Objects.requireNonNull(sdk).getId();
            this.attributes = new HashMap<String, String>();
            this.attributes.put("name", sdk.getName());
            this.attributes.put("version", sdk.getVersion());
            this.attributes.put("basePath", sdk.getBasePath());
            this.status = Status.OK_STATUS;
            this.basePathOrigin = BasePathOrigin.DEFAULT;
        }

        private String getSdkId() {
            return this.sdkId;
        }

        private String getAttribute(String attributeId) {
            return this.attributes.getOrDefault(attributeId, "");
        }

        private void setAttribute(String attributeId, String attributeValue) {
            this.attributes.put(attributeId, attributeValue);
        }

        private Map<String, String> getAttributes() {
            if (BasePathOrigin.DEFAULT == this.basePathOrigin) {
                this.setAttribute("basePath", SdkCheckBoxTableComposite.this.defaultBasePath);
            }
            return this.attributes;
        }

        private IStatus getStatus() {
            return this.status;
        }

        private IStatus validate() {
            ((WizardPage)SdkCheckBoxTableComposite.this.holderPage).setErrorMessage(null);
            String nameAttribute = this.getAttribute("name");
            String versionAttribute = this.getAttribute("version");
            this.status = SdkCheckBoxTableComposite.this.nameValidator.validate((Object)nameAttribute);
            if (this.status.isOK()) {
                this.status = SdkCheckBoxTableComposite.this.versionValidator.validate((Object)versionAttribute);
            }
            if (this.status.isOK() && SdkManagementUtils.isSdkExists((String)nameAttribute, (String)versionAttribute)) {
                this.status = SdkUiActivator.getInstance().createError(Messages.ImportSdkRenameDialog_error_sdk_with_same_name_version_exists);
            }
            if (this.status.isOK()) {
                this.status = SdkCheckBoxTableComposite.this.environmentValidator.validate((Object)this.envName);
            }
            if (this.status.isOK() && this.isSdkExistsInSelectedList(nameAttribute, versionAttribute)) {
                this.status = SdkUiActivator.getInstance().createError(Messages.ImportSdkRenameDialog_error_sdk_with_same_name_version_exists);
            }
            if (!this.status.isOK()) {
                SdkCheckBoxTableComposite.this.tableViewer.setChecked((Object)this, false);
            }
            return this.status;
        }

        private boolean isSdkExistsInSelectedList(String name, String version) {
            return Arrays.stream(SdkCheckBoxTableComposite.this.tableViewer.getCheckedElements()).filter(SdkAttributes.class::isInstance).map(SdkAttributes.class::cast).filter(as -> as != this).anyMatch(as -> as.getAttribute("name").equals(name) && as.getAttribute("version").equals(version));
        }

        private void updateEnvName() {
            this.envName = SdkEnvironmentUtils.getEnviromnentName((String)this.getAttribute("name"), (String)"version");
            this.validate();
        }

        private BasePathOrigin getBasePathOrigin() {
            return this.basePathOrigin;
        }

        private void setBasePathOrigin(BasePathOrigin basePathOrigin) {
            this.basePathOrigin = basePathOrigin;
            Event event = new Event();
            event.text = "basePath";
            SdkCheckBoxTableComposite.this.notifyListeners(1, event);
        }

        static /* synthetic */ String access$0(SdkAttributes sdkAttributes) {
            return sdkAttributes.getSdkId();
        }

        static /* synthetic */ Map access$1(SdkAttributes sdkAttributes) {
            return sdkAttributes.getAttributes();
        }
    }
}

