/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.core.internal.model.implementations;

import com.nxp.s32ds.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.rcp.collateral.CollateralPack;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import com.nxp.s32ds.rcp.collateral.core.CollateralFactory;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralFeatureImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralPackImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralRegistryImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralResourceImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralResourceTypeImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralTagImplementation;
import com.nxp.s32ds.rcp.modular.ModularPack;

public class CollateralFactoryImplementation
implements CollateralFactory {
    private CollateralFactoryImplementation() {
    }

    public static CollateralFactory getInstance() {
        return CollateralFactoryHolder.FACTORY;
    }

    @Override
    public CollateralPack createPack(String id, String name, String description, String imagePath) {
        return new CollateralPackImplementation(id, name, description, imagePath);
    }

    @Override
    public CollateralFeature createFeature(String id, String name, String description, String imagePath) {
        return new CollateralFeatureImplementation(id, name, description, imagePath);
    }

    @Override
    public CollateralResource createResource(String id, String name, String description, String urlLink, String imagePath) {
        return new CollateralResourceImplementation(id, name, description, urlLink, imagePath);
    }

    @Override
    public CollateralTag createTag(String id, String name, String description, String imagePath) {
        return new CollateralTagImplementation(id, name, description, imagePath);
    }

    @Override
    public CollateralResourceType createResourceType(String id, String name, String description, String imagePath) {
        return new CollateralResourceTypeImplementation(id, name, description, imagePath);
    }

    @Override
    public CollateralRegistry createCollateralRegistry() {
        return new CollateralRegistryImplementation();
    }

    @Override
    public void mergeModularPackAndCollateralPack(ModularPack modularPack, CollateralPack collateralPack) {
        if (collateralPack instanceof CollateralPackImplementation) {
            CollateralPackImplementation implementation = (CollateralPackImplementation)collateralPack;
            if (implementation.getName() == null || implementation.getName().isEmpty()) {
                implementation.setName(modularPack.getName());
            }
            if (implementation.getDescription() == null || implementation.getDescription().isEmpty()) {
                implementation.setDescription(modularPack.getDescription());
            }
            if (implementation.getImagePath() == null || implementation.getImagePath().isEmpty()) {
                implementation.setImage(modularPack.getIcon());
            }
            if (!modularPack.getHWFamilies().isEmpty()) {
                modularPack.getHWFamilies().stream().forEach(family -> this.addHWFamilyNameToCollateralPack(collateralPack, family.getName()));
            }
        }
    }

    @Override
    public void addHWFamilyNameToCollateralPack(CollateralPack collateralPack, String hWFamilyName) {
        if (collateralPack instanceof CollateralPackImplementation && hWFamilyName != null && !hWFamilyName.isEmpty()) {
            CollateralPackImplementation implementation = (CollateralPackImplementation)collateralPack;
            implementation.addFamilyName(hWFamilyName);
        }
    }

    /* synthetic */ CollateralFactoryImplementation(CollateralFactoryImplementation collateralFactoryImplementation) {
        this();
    }

    private static class CollateralFactoryHolder {
        private static final CollateralFactoryImplementation FACTORY = new CollateralFactoryImplementation(null);

        private CollateralFactoryHolder() {
        }
    }
}

