/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.core.internal.model.implementations;

import com.nxp.s32ds.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.rcp.collateral.CollateralListener;
import com.nxp.s32ds.rcp.collateral.CollateralObject;
import com.nxp.s32ds.rcp.collateral.CollateralPack;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import com.nxp.s32ds.rcp.collateral.core.CollateralFactory;
import com.nxp.s32ds.rcp.collateral.core.internal.CollateralMaterialsActivator;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralFeatureImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralPackImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.CollateralResourceImplementation;
import com.nxp.s32ds.rcp.collateral.core.internal.model.implementations.Messages;
import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularPack;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CollateralRegistryImplementation
implements CollateralRegistry {
    private Set<CollateralListener> listeners;
    private Set<CollateralPack> packs = new HashSet<CollateralPack>();
    private Set<CollateralTag> tags = new HashSet<CollateralTag>();
    private Set<CollateralResourceType> resourceTypes = new HashSet<CollateralResourceType>();
    private boolean isComplete;

    public CollateralRegistryImplementation() {
        this.listeners = new HashSet<CollateralListener>();
    }

    public void addPack(CollateralPack pack) {
        if (!this.packs.add(pack)) {
            this.mergePacks(pack);
        }
    }

    private void mergePacks(CollateralPack pack) {
        if (pack == null) {
            return;
        }
        CollateralPack destinationPack = this.getPackById(pack.getId());
        if (destinationPack != null) {
            for (CollateralFeature feature : pack.getFeatures()) {
                this.addCollateralFeatureToPack(feature, destinationPack);
            }
        }
    }

    public void addTag(CollateralTag tag) {
        this.tags.add(tag);
    }

    public void addResourceType(CollateralResourceType resourceType) {
        this.resourceTypes.add(resourceType);
    }

    public Set<CollateralPack> getAllPacks() {
        return Collections.unmodifiableSet(this.packs);
    }

    public Set<CollateralFeature> getPackFeatures(String packageId) {
        CollateralPack pack = this.getPackById(packageId);
        if (pack != null) {
            return pack.getFeatures();
        }
        return Collections.emptySet();
    }

    public Set<CollateralResource> getAllResources() {
        HashSet<CollateralResource> result = new HashSet<CollateralResource>();
        for (CollateralPack clPackage : this.packs) {
            for (CollateralFeature clFeature : clPackage.getFeatures()) {
                result.addAll(clFeature.getResources());
            }
        }
        return result;
    }

    public Set<CollateralResource> getFeatureResources(String featureId) {
        CollateralFeature feature = this.getFeatureById(featureId);
        if (feature != null) {
            return feature.getResources();
        }
        return Collections.emptySet();
    }

    public Set<CollateralResource> getResourcesByTag(String tagId) {
        TreeSet<CollateralResource> resources = new TreeSet<CollateralResource>(Comparator.comparing(CollateralObject::getName));
        resources.addAll(this.getAllResources().stream().filter(resource -> resource.getTags().stream().anyMatch(tag -> tag.getId().equals(tagId))).collect(Collectors.toList()));
        return resources;
    }

    public Set<CollateralResource> getResourcesByResourceType(String resourceTypeId) {
        TreeSet<CollateralResource> resources = new TreeSet<CollateralResource>(Comparator.comparing(CollateralObject::getName));
        if (resourceTypeId != null) {
            resources.addAll(this.getAllResources().stream().filter(resource -> resource.getResourceType() != null && resource.getResourceType().getId().equals(resourceTypeId)).collect(Collectors.toList()));
        } else {
            resources.addAll(this.getAllResources().stream().filter(resource -> resource.getResourceType() == null).collect(Collectors.toList()));
        }
        return resources;
    }

    public Set<CollateralResourceType> getAllResourceTypes() {
        return Collections.unmodifiableSet(this.resourceTypes);
    }

    public CollateralPack getPackById(String packageId) {
        if (packageId != null && !packageId.isEmpty()) {
            return this.packs.stream().filter(pack -> pack.getId().equals(packageId)).findFirst().orElse(null);
        }
        return null;
    }

    public CollateralFeature getFeatureById(String featureId) {
        if (featureId != null && !featureId.isEmpty()) {
            return this.packs.stream().flatMap(pack -> pack.getFeatures().stream()).filter(feature -> feature.getId().equals(featureId)).findFirst().orElse(null);
        }
        return null;
    }

    public Set<CollateralResource> getResourcesByResourcesTypeIdAndFeatureId(String resourceTypeId, String featureId) {
        TreeSet<CollateralResource> resources = new TreeSet<CollateralResource>(Comparator.comparing(CollateralObject::getName));
        CollateralFeature feature = this.getFeatureById(featureId);
        if (feature != null) {
            resources.addAll(feature.getResources().stream().filter(resource -> resource.getResourceType() != null && resource.getResourceType().getId().equals(resourceTypeId)).collect(Collectors.toList()));
        }
        return resources;
    }

    public void addCollateralFeatureToPack(CollateralFeature collateralFeature, CollateralPack pack) {
        CollateralFeature feature;
        if (pack instanceof CollateralPackImplementation && !((CollateralPackImplementation)pack).addCLFeature(collateralFeature) && (feature = this.getFeatureById(collateralFeature.getId())) != null) {
            for (CollateralResource resource : collateralFeature.getResources()) {
                this.addCollateralResourceToFeature(resource, feature);
            }
        }
        if (collateralFeature instanceof CollateralFeatureImplementation) {
            ((CollateralFeatureImplementation)collateralFeature).setPack(pack);
        }
    }

    public void addCollateralResourceToFeature(CollateralResource collateralResource, CollateralFeature collateralFeature) {
        if (collateralFeature instanceof CollateralFeatureImplementation && !((CollateralFeatureImplementation)collateralFeature).addCLResource(collateralResource)) {
            CollateralMaterialsActivator.getDefault().logWarning(Messages.bind((String)(String.valueOf(Messages.CollateralRegistryImplementation_DublicateCollateralResourceId) + collateralResource.getId()), (Object)collateralResource.getId()));
            return;
        }
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).setFeature(collateralFeature);
        }
    }

    public void addCollateralTagToResource(CollateralTag tag, CollateralResource collateralResource) {
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).addCLTag(tag);
        }
    }

    public void setCollateralResourceTypeToResource(CollateralResourceType resourceType, CollateralResource collateralResource) {
        if (collateralResource instanceof CollateralResourceImplementation) {
            ((CollateralResourceImplementation)collateralResource).setResourceType(resourceType);
        }
    }

    public Set<CollateralTag> getAllCollateralTag() {
        return Collections.unmodifiableSet(this.tags);
    }

    public void addPacks(Set<CollateralPack> inputPacks) {
        inputPacks.stream().filter(pack -> !this.packs.add((CollateralPack)pack)).forEach(this::mergePacks);
    }

    public void addCollateralListener(CollateralListener listener) {
        this.listeners.add(listener);
    }

    public void removeCollateralListener(CollateralListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllCollateralListeners() {
        this.listeners.clear();
    }

    public void combineModularAndCollateralModels() {
        Map<String, ModularPack> packId2Pack = CollateralMaterialsActivator.getDefault().getInstalledPacks().stream().collect(Collectors.toMap(ModularObject::getId, pack -> pack));
        for (CollateralPack collateralPack : this.packs) {
            if (!packId2Pack.containsKey(collateralPack.getId())) continue;
            ModularPack modularPack = packId2Pack.get(collateralPack.getId());
            CollateralFactory.INSTANCE.mergeModularPackAndCollateralPack(modularPack, collateralPack);
        }
    }

    public void setRegistryComplete() {
        this.isComplete = true;
        this.listeners.stream().forEach(CollateralListener::registryUpdated);
    }

    public boolean isRegistryComplete() {
        return this.isComplete;
    }

    public void clear() {
        this.listeners.clear();
        this.packs.clear();
    }
}

