/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.imports.processors;

import com.nxp.s32ds.cle.cdt.project.info.core.imports.PIReader;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.OptionDelta;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.ToolchainOptionProcessor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;

public class DiabToolchainOptionProcessor
extends ToolchainOptionProcessor {
    private static final String DIAB_TARGET_OPTION_NAME = "diab.mbs.option.target";
    private static final String DIAB_C_LINK_OPTION_OTHER = "diab.mbs.tool.c.linker.option.other";
    private static final String DIAB_C_LINK_OPTION_SCRIPT_FILE = "diab.mbs.tool.c.linker.option.general.scriptfile";
    private static final String DIAB_C_LINK_OPTION_NO_START = "diab.mbs.tool.c.linker.option.nostart";
    private static final String DIAB_TARGET = "-t";
    private static final String DIAB_SCRIPT_FILE_OPTION = "-Wm";
    private static final String DIAB_NO_START_OPTION = "-Ws";
    private static final String DIAB_LINK_OTHER_OPTION_PATTERN = "-Wl( ?)";
    private static final String DIAB_SCRIPT_FILE_OPTION_PATTERN = "-Wm( ?)";

    @Override
    protected List<OptionDelta> setToolChainOption(IConfiguration cfg, IOption option, PIReader piReader) {
        List<OptionDelta> result = super.setToolChainOption(cfg, option, piReader);
        IToolChain toolchain = cfg.getToolChain();
        if (option.getId().endsWith(DIAB_TARGET_OPTION_NAME)) {
            result.addAll(DiabToolchainOptionProcessor.setTargetOption(cfg, toolchain, option, piReader.getOptionsLinker()));
        }
        return result;
    }

    private static List<OptionDelta> setTargetOption(IConfiguration cfg, IToolChain toolchain, IOption option, List<String> options) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        for (String value : options) {
            if (!value.startsWith(DIAB_TARGET)) continue;
            result.add(new OptionDelta(cfg, (IHoldsOptions)toolchain, option, value.replaceFirst(DIAB_TARGET, "")));
        }
        return result;
    }

    @Override
    protected List<OptionDelta> setLinkerOption(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String id = option.getId();
        if (id.endsWith(DIAB_C_LINK_OPTION_SCRIPT_FILE)) {
            for (String linkOption2 : reader.getOptionsLinker()) {
                if (!linkOption2.startsWith(DIAB_SCRIPT_FILE_OPTION)) continue;
                String[] locations = DiabToolchainOptionProcessor.getSplittedAttributes(DIAB_SCRIPT_FILE_OPTION_PATTERN, linkOption2);
                int i = 0;
                while (i < locations.length) {
                    locations[i] = this.replaceOldProjectLocationToNewInString(locations[i], cfg, reader);
                    ++i;
                }
                result.add(new OptionDelta(cfg, (IHoldsOptions)iTool, option, locations));
                break;
            }
        }
        if (id.endsWith(DIAB_C_LINK_OPTION_NO_START)) {
            for (String linkOption2 : reader.getOptionsLinker()) {
                if (!linkOption2.startsWith(DIAB_NO_START_OPTION)) continue;
                result.add(new OptionDelta(cfg, (IHoldsOptions)iTool, option, Boolean.TRUE));
                break;
            }
        }
        if (id.endsWith(DIAB_C_LINK_OPTION_OTHER)) {
            reader.getOptionsLinker().forEach(linkOption -> result.add(new OptionDelta(cfg, (IHoldsOptions)iTool, option, DiabToolchainOptionProcessor.getSplittedAttributes(DIAB_LINK_OTHER_OPTION_PATTERN, linkOption))));
        }
        if (id.startsWith("gnu.c.link.option.paths")) {
            result.addAll(this.setLibrarySearchPath(cfg, iTool, option, reader.getOptionsLinker(), reader));
        }
        return result;
    }

    private static String[] getSplittedAttributes(String splitPattern, String value) {
        String[] opts = value.split(splitPattern);
        ArrayList<String> values = new ArrayList<String>();
        int i = 1;
        while (i < opts.length) {
            values.add(opts[i]);
            ++i;
        }
        return values.toArray(new String[0]);
    }
}

