/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.statushandlers;

import com.nxp.s32ds.ext.rcp.internal.statushandlers.EmptyStatusHandler;
import com.nxp.s32ds.ext.rcp.internal.statushandlers.Messages;
import com.nxp.s32ds.ext.rcp.internal.statushandlers.StatushandlersActivator;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlerService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class RcpStatusHandlers {
    public static final String DEFAULT_HANDLER = "com.nxp.s32ds.ext.rcp.statushandlers.defaultHandler";

    private RcpStatusHandlers() {
    }

    public static RcpStatusHandlerService getStatusHandlerService() {
        return StatushandlersActivator.getInstance().getStatusHandlerService();
    }

    public static Object handleStatus(String id, IStatus status, Object context) throws CoreException {
        Assert.isNotNull((Object)id, (String)"id");
        Assert.isNotNull((Object)status, (String)"status");
        RcpStatusHandlerService statusHandlerService = RcpStatusHandlers.getStatusHandlerService();
        RcpStatusHandler statusHandler = statusHandlerService.getStatusHandler(id);
        if (statusHandler == null) {
            StatushandlersActivator.getInstance().logError(NLS.bind((String)Messages.RcpStatusHandlers_status_handler_for_id_0_not_found, (Object)id), new IllegalStateException());
            statusHandler = new EmptyStatusHandler();
            statusHandlerService.registerStatusHandler(id, statusHandler);
        }
        return statusHandler.handleStatus(status, context);
    }
}

