/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.actions;

import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;

public class CollectAction
extends ProvisioningAction {
    public IStatus execute(Map<String, Object> params) {
        IStatus res = Status.OK_STATUS;
        IProvisioningAgent pAgent = (IProvisioningAgent)params.get("agent");
        IProfile prfl = (IProfile)params.get("profile");
        IInstallableUnit unit = (IInstallableUnit)params.get("iu");
        try {
            IArtifactRequest[] requests = this.doCollect(pAgent, unit, prfl);
            Collection ar = (Collection)params.get("artifactRequests");
            ar.add(requests);
        }
        catch (ProvisionException ex) {
            res = ex.getStatus();
        }
        return res;
    }

    public IStatus undo(Map<String, Object> params) {
        return Status.OK_STATUS;
    }

    private IArtifactRequest[] doCollect(IProvisioningAgent pAgent, IInstallableUnit iu, IProfile prfl) throws ProvisionException {
        IArtifactRequest[] result = new IArtifactRequest[]{};
        Collection toDownload = iu.getArtifacts();
        if (toDownload == null) {
            return result;
        }
        IFileArtifactRepository dst = Util.getDownloadCacheRepo(pAgent);
        IArtifactRequest[] requests = new IArtifactRequest[toDownload.size()];
        int count = 0;
        for (IArtifactKey key : toDownload) {
            requests[count] = Util.getArtifactRepositoryManager(pAgent).createMirrorRequest(key, (IArtifactRepository)dst, null, null);
            ++count;
        }
        if (requests.length == count) {
            return requests;
        }
        result = new IArtifactRequest[count];
        System.arraycopy(requests, 0, result, 0, count);
        return result;
    }
}

