/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.utils;

import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import com.nxp.s32ds.ext.rcp.p2.internal.core.Messages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class Unzip {
    private static final String ACTION_UNZIP = "unzip";

    public static IStatus unzip(Map<String, Object> parameters, boolean restoreable, String targetDir) {
        String target;
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_UNZIP));
        }
        String originalSource = source;
        String string = target = targetDir == null ? (String)parameters.get("target") : targetDir;
        if (target == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_UNZIP));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                return Util.createErrorMessage(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = artifactLocation;
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        try {
            File[] unzippedFiles = Unzip.unzip(source, target, store);
            StringBuffer unzippedFileNameBuffer = new StringBuffer();
            File[] fileArray = unzippedFiles;
            int n = unzippedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File unzippedFile = fileArray[n2];
                unzippedFileNameBuffer.append(unzippedFile.getAbsolutePath()).append("|");
                ++n2;
            }
            profile.setInstallableUnitProperty(iu, "unzipped|" + originalSource + "|" + target, unzippedFileNameBuffer.toString());
        }
        catch (Exception e) {
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", Messages.Unzip_error, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private static File[] unzip(String source, String destination, IBackupStore store) throws IOException {
        File zipFile = new File(source);
        if (!zipFile.exists()) {
            Util.logError(NLS.bind((String)Messages.Unzip_the_files_is_not_here, (Object)Unzip.class.getName()));
        }
        return Unzip.unzipFile(zipFile, new File(destination), store);
    }

    private static File[] unzipFile(File file, File outputDir, IBackupStore store) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream in = new FileInputStream(file);){
                return Unzip.unzipStream(in, outputDir, store);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)file, (Object)e.getMessage()));
        }
    }

    private static File[] unzipStream(InputStream stream, File outputDir, IBackupStore store) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(stream));){
            ZipEntry ze = in.getNextEntry();
            if (ze == null) {
                throw new IOException(Messages.Util_Invalid_Zip_File_Format);
            }
            ArrayList<File> unzippedFiles = new ArrayList<File>();
            do {
                File outFile = new File(outputDir, ze.getName());
                unzippedFiles.add(outFile);
                if (ze.isDirectory()) {
                    if (!outFile.mkdirs()) {
                        throw new IOException(Messages.Unzip_create_out_file_error);
                    }
                } else {
                    if (outFile.exists()) {
                        if (store != null) {
                            store.backup(outFile);
                        } else {
                            outFile.delete();
                        }
                    } else {
                        outFile.getParentFile().mkdirs();
                    }
                    try {
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (FileOutputStream fos = new FileOutputStream(outFile);){
                            Util.copyStream(in, false, fos, true);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (FileNotFoundException e) {
                        Util.logWarning(NLS.bind((String)Messages.Unzip_copy_stream_error, (Object)e.getMessage()));
                    }
                    outFile.setLastModified(ze.getTime());
                }
                in.closeEntry();
            } while ((ze = in.getNextEntry()) != null);
            return unzippedFiles.toArray(new File[unzippedFiles.size()]);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static IStatus unzipCopy(Map<String, Object> parameters, boolean restoreable, List<File> filelist) throws URISyntaxException {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_UNZIP));
        }
        String originalSource = source;
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_UNZIP));
        }
        Location location = Platform.getConfigurationLocation();
        Location eclipse = Platform.getInstallLocation();
        if (location != null && eclipse != null) {
            try {
                IPath pathTemp = Util.getLocationIPath(location);
                IPath eclipsePath = Util.getLocationIPath(eclipse);
                if (!eclipsePath.isPrefixOf(pathTemp)) {
                    pathTemp = pathTemp.removeLastSegments(1);
                    pathTemp = pathTemp.addTrailingSeparator();
                    String firstString = eclipsePath.toString();
                    String secondString = pathTemp.toString();
                    target = target.replace("\\", "/");
                    target = target.replace(firstString, secondString);
                    Util.logWarning(String.format("%s is the new (USER) target parameter.%n", target));
                }
            }
            catch (URISyntaxException e) {
                Util.logWarning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            Util.logError(String.format("FAIL to compute/validate/re-create target parameter.%n", new Object[0]));
            return Status.CANCEL_STATUS;
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                return Util.createErrorMessage(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = artifactLocation;
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        try {
            File[] unzippedFiles = Unzip.unzip(source, target, store);
            StringBuffer unzippedFileNameBuffer = new StringBuffer();
            unzippedFileNameBuffer.ensureCapacity(unzippedFiles.length * 260);
            File[] fileArray = unzippedFiles;
            int n = unzippedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File unzippedFile = fileArray[n2];
                unzippedFileNameBuffer.append(unzippedFile.getAbsolutePath()).append("|");
                filelist.add(unzippedFile);
                ++n2;
            }
            profile.setInstallableUnitProperty(iu, "copied|" + originalSource + "|" + target, unzippedFileNameBuffer.toString());
        }
        catch (Exception e) {
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", Messages.Unzip_error, (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

