/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.api.interpolator;

import java.util.ArrayList;
import org.pushingpixels.trident.api.ease.Linear;
import org.pushingpixels.trident.api.ease.TimelineEase;

class KeyInterpolators {
    private ArrayList<TimelineEase> interpolators = new ArrayList();

    KeyInterpolators(int numIntervals, TimelineEase ... interpolators) {
        if (interpolators == null || interpolators[0] == null) {
            int i = 0;
            while (i < numIntervals) {
                this.interpolators.add(new Linear());
                ++i;
            }
        } else if (interpolators.length < numIntervals) {
            int i = 0;
            while (i < numIntervals) {
                this.interpolators.add(interpolators[0]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numIntervals) {
                this.interpolators.add(interpolators[i]);
                ++i;
            }
        }
    }

    float interpolate(int interval, float fraction) {
        return this.interpolators.get(interval).map(fraction);
    }
}

