/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class DumpHelper {
    private DumpHelper() {
    }

    public static StringBuilder dump(StringBuilder builder, DumpFormatOptions options, IChildProvidable providableSetting) {
        builder.append("\n");
        DumpHelper.createIndentation(builder, options);
        DumpHelper.appendCommonStart(builder, providableSetting);
        builder.append(" id: ").append(providableSetting.getId());
        DumpHelper.appendEnableAvailable(builder, providableSetting);
        builder.append(", ").append("settings: ").append("{");
        DumpFormatOptions optionsForChildren = new DumpFormatOptions(options).indentation(options.getIndentation() + 1);
        List<? extends IChild> children = providableSetting.getChildren();
        for (IChild iChild : children) {
            iChild.dump(builder, optionsForChildren);
        }
        builder.append("\n");
        DumpHelper.createIndentation(builder, options);
        builder.append("}").append("]");
        return builder;
    }

    public static StringBuilder dump(StringBuilder builder, DumpFormatOptions options, ScalarConfig scalarSetting) {
        if (scalarSetting.getType() == ScalarConfig.Type.VARIABLE && !options.shouldDumpVariables()) {
            return builder;
        }
        if (scalarSetting.getType() == ScalarConfig.Type.INFO && !options.shouldDumpInfos()) {
            return builder;
        }
        builder.append("\n");
        DumpHelper.createIndentation(builder, options);
        DumpHelper.appendCommonStart(builder, scalarSetting);
        builder.append(" id: ").append(scalarSetting.getId()).append(", ").append("value: ").append(scalarSetting.getStringValue());
        DumpHelper.appendEnableAvailable(builder, scalarSetting);
        builder.append("]");
        return builder;
    }

    public static StringBuilder dump(StringBuilder builder, DumpFormatOptions options, SetConfig.SetPresence setPresence) {
        builder.append("\n");
        DumpHelper.createIndentation(builder, options);
        DumpHelper.appendCommonStart(builder, setPresence);
        builder.append(" name: ").append(setPresence.getName()).append(", ").append("value: ").append(setPresence.getBoolValue());
        DumpHelper.appendEnableAvailable(builder, setPresence);
        builder.append("]");
        return builder;
    }

    public static void dumpChildToFile(IChild child, String fileName) {
        String string = DumpHelper.getStringDump(child);
        byte[] bytesToWrite = string.getBytes(StandardCharsets.UTF_8);
        UtilsFile.writeFile((String)fileName, (byte[])bytesToWrite);
    }

    public static String getStringDump(IChild child) {
        StringBuilder builder = new StringBuilder();
        child.dump(builder, new DumpFormatOptions());
        return builder.toString();
    }

    private static void createIndentation(StringBuilder builder, DumpFormatOptions options) {
        int i = 0;
        while (i < options.getIndentation()) {
            builder.append("\t");
            ++i;
        }
    }

    private static StringBuilder appendCommonStart(StringBuilder builder, IChild child) {
        builder.append("[").append(child.getClass().getSimpleName());
        return builder;
    }

    private static StringBuilder appendEnableAvailable(StringBuilder builder, IChild child) {
        builder.append(", available: ").append(child.isAvailable());
        builder.append(", enabled: ").append(child.isEnabled());
        return builder;
    }
}

