/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsArraySetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsScalarSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsSetSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsStructSetting;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.EnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.InfoSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import com.nxp.swtools.resourcetables.model.data.setting.VariableSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingConfigFactory {
    private static final Logger LOGGER = LogManager.getLogger(SettingConfigFactory.class);

    public ISettingConfig createSettingConfig(String id, String name, ISetting setting, ChildContext parentContext, ICommonMcu mcu) {
        if (setting instanceof ReferenceSetting) {
            throw new IllegalArgumentException("Tried to create config (component item) from unresolved reference with id: '" + setting.getId() + "' setting.");
        }
        ISettingConfig settingConfig = null;
        settingConfig = setting instanceof StructSetting ? this.createStructConfig(id, name, setting, parentContext, mcu, null) : (setting instanceof ArraySetting ? this.createArrayConfig(id, name, setting, parentContext, mcu, null) : (setting instanceof SetSetting && !(setting instanceof EnumSetting) ? new SetConfig(id, name, setting, parentContext, mcu) : new ScalarConfig(id, name, setting, parentContext, mcu)));
        return settingConfig;
    }

    public ISettingConfig createSettingConfig(String id, ISetting setting, ChildContext parentContext, AStoragePeriphsSetting storageSetting, ICommonMcu mcu) {
        if (setting instanceof ReferenceSetting) {
            throw new IllegalArgumentException("Invalid " + ISetting.class.getName() + " class: " + setting.getClass().getName());
        }
        ISettingConfig settingConfig = null;
        boolean isDifferentType = false;
        if (setting instanceof StructSetting) {
            if (storageSetting instanceof StoragePeriphsStructSetting) {
                settingConfig = this.createStructConfig(id, storageSetting.getName(), setting, parentContext, mcu, storageSetting);
            } else {
                isDifferentType = true;
                settingConfig = this.createStructConfig(id, storageSetting.getName(), setting, parentContext, mcu, null);
            }
        } else if (setting instanceof ArraySetting) {
            if (storageSetting instanceof StoragePeriphsArraySetting) {
                settingConfig = this.createArrayConfig(id, storageSetting.getName(), setting, parentContext, mcu, storageSetting);
            } else {
                isDifferentType = true;
                settingConfig = this.createArrayConfig(id, storageSetting.getName(), setting, parentContext, mcu, null);
            }
        } else if (setting instanceof SetSetting && !(setting instanceof EnumSetting)) {
            if (storageSetting instanceof StoragePeriphsSetSetting) {
                settingConfig = new SetConfig(id, setting, parentContext, (StoragePeriphsSetSetting)storageSetting, mcu);
            } else {
                isDifferentType = true;
                settingConfig = new SetConfig(id, storageSetting.getName(), setting, parentContext, mcu);
            }
        } else if (setting instanceof VariableSetting || setting instanceof InfoSetting) {
            isDifferentType = true;
            settingConfig = new ScalarConfig(id, storageSetting.getName(), setting, parentContext, mcu);
        } else if (storageSetting instanceof StoragePeriphsScalarSetting) {
            settingConfig = new ScalarConfig(id, setting, parentContext, (StoragePeriphsScalarSetting)storageSetting, mcu);
        } else {
            isDifferentType = true;
            settingConfig = new ScalarConfig(id, storageSetting.getName(), setting, parentContext, mcu);
        }
        if (isDifferentType) {
            IComponentConfig componentConfig = parentContext.getComponentConfig();
            String message = new String("[SDK/DATA] Load from MEX/YAML: type of the setting with ID \"{0}\" differs from the component definition, therefore its value cannot be restored. Type from MEX/YAML: \"{1}\", type from the component definition: \"{2}\", component: \"{3}\".");
            LOGGER.log(Level.SEVERE, MessageFormat.format(message, storageSetting.getName(), storageSetting.getClass().getSimpleName(), setting.getClass().getSimpleName(), componentConfig == null ? "unknown" : componentConfig.getComponentTypeId()));
        }
        return settingConfig;
    }

    protected ISettingConfig createStructConfig(String id, String name, ISetting setting, ChildContext parentContext, ICommonMcu mcu, @Nullable AStoragePeriphsSetting storageSetting) {
        if (storageSetting != null) {
            return new StructConfig(id, setting, parentContext, (StoragePeriphsStructSetting)storageSetting, mcu);
        }
        return new StructConfig(id, name, setting, parentContext, mcu);
    }

    protected ISettingConfig createArrayConfig(String id, String name, ISetting setting, ChildContext parentContext, ICommonMcu mcu, @Nullable AStoragePeriphsSetting storageSetting) {
        if (storageSetting != null) {
            return new ArrayConfig(id, setting, parentContext, (StoragePeriphsArraySetting)storageSetting, mcu);
        }
        return new ArrayConfig(id, name, setting, parentContext, mcu);
    }
}

