/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.ErrorLevels;
import com.nxp.swtools.provider.configuration.dependencies.DependencyCreator;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyFeature;
import com.nxp.swtools.provider.configuration.dependencies.IFeatureData;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeature;
import com.nxp.swtools.resourcetables.model.data.ComponentLoadingStatus;
import com.nxp.swtools.resourcetables.model.data.Data;
import com.nxp.swtools.resourcetables.model.data.Feature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.osgi.framework.Version;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(name="dependency", strict=false)
public class Dependency
implements IDependency {
    private static final Logger LOGGER = LogManager.getLogger(Dependency.class);
    @Nullable
    private Expression whenExpr;
    @Attribute(name="resource_type", required=true)
    private String resourceType = "";
    @Attribute(name="resource_id", required=false)
    @Nullable
    private @Attribute(name="resource_id", required=false) @Nullable String resourceId;
    @Nullable
    private Expression resourceIdExpr;
    @Attribute(name="description", required=false)
    @Nullable
    private @Attribute(name="description", required=false) @Nullable String description;
    @Nullable
    private Expression descriptionExpr;
    @Attribute(name="level", required=true)
    private String level = "";
    @ElementList(type=Feature.class, required=true, inline=true)
    private List<IDependencyFeature> features;

    @Attribute(name="description_expr", required=false)
    private @Attribute(name="description_expr", required=false) @Nullable String getDescriptionExprString() {
        return Expression.formatOutput((Expression)this.descriptionExpr, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="resource_id_expr", required=false)
    private @Attribute(name="resource_id_expr", required=false) @Nullable String getResourceIdExprString() {
        return Expression.formatOutput((Expression)this.resourceIdExpr, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="when_expr", required=false)
    private @Attribute(name="when_expr", required=false) @Nullable String getWhenExprString() {
        return Expression.formatOutput((Expression)this.whenExpr, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="description_expr", required=false)
    private void setDescriptionExprString(@Nullable String newDesc) {
        this.descriptionExpr = newDesc != null && !newDesc.isEmpty() ? Expression.tryCreate((String)newDesc) : null;
    }

    @Attribute(name="resource_id_expr", required=false)
    private void setResourceIdExprString(@Nullable String newId) {
        this.resourceIdExpr = newId != null && !newId.isEmpty() ? Expression.tryCreate((String)newId) : null;
    }

    @Attribute(name="when_expr", required=false)
    private void setWhenExprString(@Nullable String newWhen) {
        this.whenExpr = newWhen != null && !newWhen.isEmpty() ? Expression.tryCreate((String)newWhen) : null;
    }

    public Dependency(@Nullable String whenExpr, String resourceType, @Nullable String resourceId, @Nullable String resourceIdExpr, String level, @Nullable String description, @Nullable String descriptionExpr) {
        assert (resourceId != null || resourceIdExpr != null);
        assert (description != null || descriptionExpr != null);
        this.setWhenExprString(whenExpr);
        this.setResourceIdExprString(resourceIdExpr);
        this.setDescriptionExprString(descriptionExpr);
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.level = level;
        this.description = description;
        this.features = new ArrayList<IDependencyFeature>();
    }

    @Deprecated
    protected Dependency() {
        this("", "", null, "", "", null, "");
    }

    public DependencyCreator getDependencyCreator() {
        return DependencyCreator.UNKNOWN;
    }

    public String getDescription() {
        return UtilsText.safeString((String)this.description);
    }

    public boolean isDescriptionEmpty() {
        return this.descriptionExpr == null && UtilsText.isEmpty((String)this.description);
    }

    public Collection<IDependencyFeature> getFeatures() {
        return this.features;
    }

    public String getLevel() {
        return this.level;
    }

    public int getProblemlevel() {
        return ErrorLevels.textToLevel((String)this.level);
    }

    public String getResourceId() {
        return UtilsText.safeString((String)this.resourceId);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getSource() {
        return "";
    }

    public @Nullable StorageDependency resolve(IContext expressionContext, String source, String originatorId) {
        String resId;
        String desc;
        if (this.whenExpr != null && !this.whenExpr.resolve(expressionContext).getBoolean()) {
            return null;
        }
        StorageDependency result = new StorageDependency();
        result.setDependencyCreator(DependencyCreator.TOOL);
        result.setDependencyCreator(DependencyCreator.TOOL);
        if (this.descriptionExpr != null) {
            try {
                desc = this.descriptionExpr.resolve(expressionContext).getString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            catch (ExpressionException exception) {
                exception.log();
                return null;
            }
        } else {
            desc = this.getDescription();
        }
        if (this.resourceIdExpr != null) {
            try {
                resId = this.resourceIdExpr.resolve(expressionContext).getString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            catch (ExpressionException exception) {
                exception.log();
                return null;
            }
        } else {
            resId = this.getResourceId();
        }
        result.setDescription(desc);
        ArrayList<StorageDependencyFeature> resultFeatures = new ArrayList<StorageDependencyFeature>();
        for (IDependencyFeature feature : this.features) {
            StorageDependencyFeature f = new StorageDependencyFeature();
            resultFeatures.add(f);
            f.setName(feature.getName());
            f.setEvaluation(feature.getEvaluation());
            f.setConfiguration(feature.getConfiguration());
            for (IFeatureData data : feature.getData()) {
                if (data instanceof Data) {
                    IValue value = ((Data)data).resolveValue(expressionContext);
                    if (value.getValue() instanceof Collection) {
                        Collection valueSet = (Collection)value.getValue();
                        for (Object setMember : valueSet) {
                            assert (setMember != null);
                            Value memberValue = Value.of(setMember);
                            String type = data.getType() == null ? Dependency.determineFeatureDataType((IValue)memberValue) : data.getType();
                            f.addData(UtilsText.safeString((String)memberValue.getString()), type, data.getUnit(), data.getMinValue(), data.getMaxValue());
                        }
                        continue;
                    }
                    String type = data.getType() == null ? Dependency.determineFeatureDataType(value) : data.getType();
                    f.addData(value.getString(), type, data.getUnit(), data.getMinValue(), data.getMaxValue());
                    continue;
                }
                f.addData(data.getValue(), data.getType(), data.getUnit(), data.getMinValue(), data.getMaxValue());
            }
        }
        result.setFeatures(resultFeatures);
        result.setProblemLevel(this.getProblemlevel());
        result.setResourceId(resId);
        result.setResourceType(this.resourceType);
        result.setSource(source);
        result.setOriginatorId(originatorId);
        return result;
    }

    private static @Nullable String determineFeatureDataType(IValue value) {
        switch (value.getType()) {
            case LONG: {
                return "Integer";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case STRING: {
                return "String";
            }
            case OBJECT: {
                if (!(value.getValue() instanceof Version)) break;
                return "Version";
            }
        }
        return null;
    }

    public void setFeatures(List<IDependencyFeature> newFeat) {
        this.features = newFeat;
    }

    public void addFeature(IDependencyFeature newFeat) {
        this.features.add(newFeat);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "when_expr" + "=" + this.getWhenExprString() + ", " + "resource_type" + "=" + this.getResourceType() + ", " + "resource_id" + "=" + this.getResourceId() + ", " + "resource_id_expr" + "=" + this.getResourceIdExprString() + ", " + "level" + "=" + this.getLevel() + ", " + "description" + "=" + this.getDescription() + ", " + "description_expr" + "=" + this.getDescriptionExprString() + ", features=" + this.getFeatures() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.whenExpr);
        result = 31 * result + this.resourceType.hashCode();
        result = 31 * result + Objects.hashCode(this.resourceId);
        result = 31 * result + Objects.hashCode(this.resourceIdExpr);
        result = 31 * result + this.level.hashCode();
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.descriptionExpr);
        result = 31 * result + this.features.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (!Objects.equals(this.whenExpr, other.whenExpr)) {
            return false;
        }
        if (!this.resourceType.equals(other.resourceType)) {
            return false;
        }
        if (!Objects.equals(this.resourceId, other.resourceId)) {
            return false;
        }
        if (!Objects.equals(this.resourceIdExpr, other.resourceIdExpr)) {
            return false;
        }
        if (!this.level.equals(other.level)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.descriptionExpr, other.descriptionExpr)) {
            return false;
        }
        return this.features.equals(other.features);
    }

    @Validate
    public void validate() {
        if (UtilsText.isEmpty((String)this.resourceId) && this.resourceIdExpr == null) {
            LOGGER.severe(MessageFormat.format("[DATA] [DEPENDENCY] [{0}] Missing both resource_id and resource_id_expr", ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent()));
        }
        if (UtilsText.isEmpty((String)this.description) && this.descriptionExpr == null) {
            LOGGER.severe(MessageFormat.format("[DATA] [DEPENDENCY] [{0}] Missing both description and description_expr", ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent()));
        }
    }

    public boolean getBootInitOnly() {
        return false;
    }
}

