/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.resourcetables.model.data.ComponentLoadingStatus;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.core.Commit;

@Root(name="description", strict=false)
public class Description {
    private static final Logger LOGGER = LogManager.getLogger(Description.class);
    @Nullable
    private Expression expr;
    @Text(required=false)
    @Nullable
    private @Text(required=false) @Nullable String descriptionText;

    public Description(@Nullable String descriptionText, @Nullable String expr) {
        this.descriptionText = descriptionText;
        if (expr != null) {
            this.setExprString(expr);
        }
    }

    @Deprecated
    protected Description() {
    }

    @Attribute(name="expr", required=false)
    public @Attribute(name="expr", required=false) @Nullable String getExprString() {
        return Expression.formatOutput((Expression)this.expr, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="expr", required=false)
    private void setExprString(String newExpr) {
        if (!newExpr.isEmpty()) {
            this.expr = Expression.tryCreate((String)newExpr);
        }
    }

    public @Nullable String getDescriptionText() {
        return this.descriptionText;
    }

    public void setDescriptionText(@Nullable String newDescriptionText) {
        if (this.expr != null) {
            LOGGER.warning(MessageFormat.format("[DATA] [DESCRIPTION] [{0}] Description text cannot be set, because {1} attribute is defined and it takes priority over description text", ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), "expr"));
            return;
        }
        this.descriptionText = newDescriptionText;
    }

    public @Nullable String getDescription(IContext context) {
        if (this.expr != null) {
            return this.expr.resolve(context).getString();
        }
        return this.getDescriptionText();
    }

    @Commit
    private void commit() {
        if (SWToolsProperties.isVerificationOn() && this.expr != null && this.descriptionText != null) {
            LOGGER.warning(MessageFormat.format("[DATA] [DESCRIPTION] [{0}] Description element contains textual content even though expr tag is defined", ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent()));
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + "expr = " + this.getExprString() + ", descriptionText = " + this.getDescriptionText() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.expr);
        result = 31 * result + Objects.hashCode(this.descriptionText);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Description other = (Description)obj;
        if (!Objects.equals(this.expr, other.expr)) {
            return false;
        }
        return Objects.equals(this.descriptionText, other.descriptionText);
    }
}

