/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.resourcetables.model.data.ComponentLoadingStatus;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSelectionGroup;
import com.nxp.swtools.resourcetables.model.data.QuickSelection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(name="quick_selections", strict=false)
public class QuickSelectionsGroup
implements IQuickSelectionGroup {
    private static final Logger LOGGER = LogManager.getLogger(QuickSelectionsGroup.class);
    @ElementList(inline=true, required=false, type=QuickSelection.class)
    private ArrayList<IQuickSelection> qSelections;
    @Element(name="default", required=false)
    @Nullable
    private @Element(name="default", required=false) @Nullable String defaultQSRef;
    private List<IQuickSelection> defaultQS;

    public QuickSelectionsGroup() {
        this.qSelections = new ArrayList();
        this.defaultQS = new ArrayList<IQuickSelection>();
    }

    public QuickSelectionsGroup(QuickSelectionsGroup original) {
        this.qSelections = new ArrayList<IQuickSelection>(original.getQuickSelections());
        this.defaultQS = new ArrayList<IQuickSelection>(original.getDefaultQS());
    }

    @Validate
    private void validate() {
        if (!UtilsText.isEmpty((String)this.defaultQSRef)) {
            List<IQuickSelection> def = this.getQuickSelectionsById(UtilsText.safeString((String)this.defaultQSRef));
            if (!def.isEmpty()) {
                this.defaultQS = def;
            } else if (SWToolsProperties.isVerificationOn()) {
                LOGGER.log(Level.WARNING, MessageFormat.format("[DATA] [QUICK_SELECTION_GROUP] [{0}] Cannot find default quick selection with ID \"{1}\"", ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), this.defaultQSRef));
            }
        }
    }

    private List<IQuickSelection> getQuickSelectionsById(String id) {
        return (List)this.qSelections.stream().filter(x -> x.getId().equals(id)).collect(CollectorsUtils.toList());
    }

    @Override
    public List<IQuickSelection> getQuickSelections() {
        return CollectionsUtils.unmodifiableList(this.qSelections);
    }

    @Override
    public boolean addQuickSelection(IQuickSelection quickSelection) {
        return this.qSelections.add(quickSelection);
    }

    @Override
    public void setDefaultQS(IQuickSelection qs) {
        if (this.qSelections.contains(qs)) {
            this.defaultQS.clear();
            this.defaultQS.add(qs);
            this.defaultQSRef = qs.getId();
            return;
        }
        throw new IllegalArgumentException(qs + " cannot be set as default, as it is not listed in " + this.qSelections);
    }

    @Override
    public void setDefaultQuickSelectionById(@Nullable String qsId) throws IllegalArgumentException {
        this.defaultQSRef = qsId;
        if (qsId == null) {
            return;
        }
        List<IQuickSelection> quickSelectionsById = this.getQuickSelectionsById(qsId);
        if (this.qSelections.containsAll(quickSelectionsById)) {
            this.defaultQS.clear();
            this.defaultQS.addAll(quickSelectionsById);
            return;
        }
        throw new IllegalArgumentException(String.valueOf(qsId) + " cannot be set as default, as it is not listed in " + this.qSelections);
    }

    @Override
    public @Nullable String getDefaultQuickSelectionId() {
        return this.defaultQSRef;
    }

    @Override
    public List<IQuickSelection> getDefaultQS() {
        return this.defaultQS;
    }

    @Override
    public boolean hasQuickSelections() {
        return !this.qSelections.isEmpty();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.defaultQS);
        result = 31 * result + Objects.hashCode(this.defaultQSRef);
        result = 31 * result + this.qSelections.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuickSelectionsGroup other = (QuickSelectionsGroup)obj;
        if (!Objects.equals(this.defaultQSRef, other.defaultQSRef)) {
            return false;
        }
        if (!Objects.equals(this.defaultQS, other.defaultQS)) {
            return false;
        }
        return this.qSelections.equals(other.qSelections);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + (UtilsText.isEmpty((String)this.defaultQSRef) ? "" : "default=" + this.defaultQSRef + ", ") + "quickSelections(fst " + 3 + ")=" + CollectionsUtils.firstN(this.qSelections, (int)3) + "]";
    }
}

