/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.core.service.scriptapi.db.IRegClockGateConfigAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegClockGateConfigStateAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.resourcetables.model.config.ExpressionFunctions;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.utils.scripting.api.IRegisterModelAPI;
import java.math.BigInteger;

public class RegisterModelAPI
implements IRegisterModelAPI {
    @Nullable
    IRegistersDatabaseAPI registersDb;

    public RegisterModelAPI(@Nullable IRegistersDatabaseAPI registersDb) {
        this.registersDb = registersDb;
    }

    public BigInteger getBitFieldResetValue(String peripheralIdentification, String registerIdentification, String bitfieldIdentification) {
        return RegistersModelSingleton.getResetValueOfBitfieldInternal(this.registersDb, peripheralIdentification, registerIdentification, bitfieldIdentification);
    }

    public BigInteger getRegisterResetValue(String peripherlIdentification, String registerIdentification) {
        return RegistersModelSingleton.getResetValueOfRegisterInternal(this.registersDb, peripherlIdentification, registerIdentification);
    }

    public BigInteger getRegisterAddress(String peripheralIdentification, String registerIdentification, String coreId) {
        return ExpressionFunctions.getAddressOfRegisterInternal(this.registersDb, peripheralIdentification, registerIdentification, coreId, null);
    }

    public BigInteger getRegisterAddress(String peripheralIdentification, String registerIdentification, String coreId, @Nullable String mode) {
        return ExpressionFunctions.getAddressOfRegisterInternal(this.registersDb, peripheralIdentification, registerIdentification, coreId, mode);
    }

    public BigInteger getBitfieldOffset(String peripheralIdentification, String registerIdentification, String bitfieldIdentification) {
        return ExpressionFunctions.getOffsetOfBitfieldInternal(this.registersDb, peripheralIdentification, registerIdentification, bitfieldIdentification);
    }

    public String[] getRegisters(String peripheralIdentification) {
        return ExpressionFunctions.getRegistersInternal(this.registersDb, peripheralIdentification).toArray(new String[0]);
    }

    public String[] getBitfields(String peripheralIdentification, String registerIdentification) {
        return ExpressionFunctions.getBitfieldsInternal(this.registersDb, peripheralIdentification, registerIdentification).toArray(new String[0]);
    }

    public @Nullable IRegistersDatabaseAPI getRegisterDb() {
        return this.registersDb;
    }

    public BigInteger getBitFieldWidth(String peripheralIdentification, String registerIdentification, String bitfieldIdentification) {
        return ExpressionFunctions.getBitFieldWidthInternal(this.registersDb, peripheralIdentification, registerIdentification, bitfieldIdentification);
    }

    public boolean peripheralExists(String peripheralIdentification) {
        return ExpressionFunctions.peripheralExists(this.registersDb, peripheralIdentification);
    }

    public boolean registerExists(String peripheralIdentification, String registerIdentification) {
        return ExpressionFunctions.registerExists(this.registersDb, peripheralIdentification, registerIdentification);
    }

    public boolean bitfieldExists(String peripheralIdentification, String registerIdentification, String bitfieldIdentification) {
        return ExpressionFunctions.bitfieldExists(this.registersDb, peripheralIdentification, registerIdentification, bitfieldIdentification);
    }

    public BigInteger getPeripheralBaseAddress(String peripheralIdentification, String coreId) {
        return ExpressionFunctions.getPeripheralBaseAddressInternal(this.registersDb, peripheralIdentification, coreId, null);
    }

    public BigInteger getPeripheralBaseAddress(String peripheralIdentification, String coreId, @Nullable String mode) {
        return ExpressionFunctions.getPeripheralBaseAddressInternal(this.registersDb, peripheralIdentification, coreId, mode);
    }

    public BigInteger getRegisterOffset(String peripheralIndentification, String registerIdentification) {
        return ExpressionFunctions.getRegisterOffsetInternal(this.registersDb, peripheralIndentification, registerIdentification);
    }

    public BigInteger getRegisterWidth(String peripheralIndentification, String registerIdentification) {
        return ExpressionFunctions.getRegisterWidthInternal(this.registersDb, peripheralIndentification, registerIdentification);
    }

    public @Nullable String getClockGatePeripheral(String peripheralIdentification) {
        IRegClockGateConfigAPI clockGate = ExpressionFunctions.getClockGateInternal(this.registersDb, peripheralIdentification, null);
        if (clockGate == null) {
            return null;
        }
        return clockGate.getControlPeripheralName();
    }

    public @Nullable String getClockGateRegister(String peripheralIdentification) {
        IRegClockGateConfigAPI clockGate = ExpressionFunctions.getClockGateInternal(this.registersDb, peripheralIdentification, null);
        if (clockGate == null) {
            return null;
        }
        return clockGate.getControlRegisterName();
    }

    public @Nullable String getClockGateBitField(String peripheralIdentification) {
        IRegClockGateConfigAPI clockGate = ExpressionFunctions.getClockGateInternal(this.registersDb, peripheralIdentification, null);
        if (clockGate == null) {
            return null;
        }
        return clockGate.getControlBitFieldName();
    }

    public @Nullable BigInteger getClockGateEnableValue(String peripheralIdentification) {
        IRegClockGateConfigAPI clockGate = ExpressionFunctions.getClockGateInternal(this.registersDb, peripheralIdentification, null);
        if (clockGate == null) {
            return null;
        }
        IRegClockGateConfigStateAPI state = clockGate.getState("enabled");
        if (state == null) {
            return null;
        }
        return BigInteger.valueOf(state.getValue());
    }

    public @Nullable String getRegisterName(String peripheralIndentification, String registerIdentification) {
        return (String)ExpressionFunctions.getRegisterNameInternal(this.registersDb, peripheralIndentification, registerIdentification).getFirst();
    }

    public @Nullable String getPeripheralAliasValue(String peripheralIndentification, String aliasType) {
        return (String)ExpressionFunctions.getPeripheralAliasValueInternal(this.registersDb, peripheralIndentification, aliasType).getFirst();
    }

    public @Nullable String getRegisterAliasValue(String peripheralIndentification, String registerIdentification, String aliasType) {
        return (String)ExpressionFunctions.getRegisterAliasValueInternal(this.registersDb, peripheralIndentification, registerIdentification, aliasType).getFirst();
    }

    public @Nullable String getBitFieldAliasValue(String peripheralIndentification, String registerIdentification, String bitFieldIdentification, String aliasType) {
        return (String)ExpressionFunctions.getBitFieldAliasValueInternal(this.registersDb, peripheralIndentification, registerIdentification, bitFieldIdentification, aliasType).getFirst();
    }
}

