/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.Option;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.OptionsMap;
import com.nxp.swtools.resourcetables.model.data.SettingOptions;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingUtils {
    private static final Logger LOGGER = LogManager.getLogger(SettingUtils.class);
    public static final String SEPARATOR = ".";
    public static final String SEPARATOR_REGEX = "\\.";
    public static final String DUPLICATE_ID_ENTRY_S2 = "[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.";
    public static final String RELATED_SETTINGS_STORAGE_VALUE = "related_settings_auto";

    private SettingUtils() {
    }

    public static @Nullable ISetting resolve(@Nullable ISetting setting, Collection<IConfigurationComponent> context) {
        ISetting tmp = setting;
        ISetting prev = null;
        while (tmp != null && tmp instanceof ReferenceSetting && prev != tmp) {
            ReferenceSetting r = (ReferenceSetting)tmp;
            prev = tmp;
            tmp = (ISetting)CollectionsUtils.nullableOptionalGet(SettingUtils.findSetting(r.getReferenceID(), context));
        }
        return tmp;
    }

    private static Optional<@Nullable ISetting> findSetting(String id, Collection<IConfigurationComponent> context) {
        return context.stream().flatMap(x -> x.getConfigSets().stream()).map(x -> x.find(id.split(SEPARATOR_REGEX))).filter(Objects::nonNull).findFirst();
    }

    public static @Nullable ISetting resolve(String id, Collection<IConfigurationComponent> context) {
        return SettingUtils.resolve((ISetting)CollectionsUtils.nullableOptionalGet(SettingUtils.findSetting(id, context)), context);
    }

    public static final String buildId(String ... parts) {
        return String.join((CharSequence)SEPARATOR, parts);
    }

    public static final String buildId(Iterable<? extends CharSequence> parts) {
        return String.join((CharSequence)SEPARATOR, parts);
    }

    public static OptionsMap createOptionsMap(@Nullable String optionsString, IID iid) {
        OptionsMap optionsMap = new OptionsMap();
        if (optionsString != null) {
            SettingUtils.addOptionsToOptionsMap(optionsString, iid, optionsMap);
        }
        return optionsMap;
    }

    public static void addOptionsToOptionsMap(String optionsString, IID iid, OptionsMap optionsMap) {
        String[] optionsArray;
        String[] stringArray = optionsArray = optionsString.split(";");
        int n = optionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Expression value = null;
            String[] optionParts = string.split("=");
            if (optionParts.length > 2) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Setting with ID \"{0}\" contains {1} assignments ({2}) to option with ID \"{3}\"", iid.getId(), optionParts.length - 1, "=", optionParts[0]));
            }
            if (optionParts.length == 2) {
                String valueString = optionParts[1].trim();
                String normalizedValue = SettingOptions.normalize(valueString);
                value = Expression.constant((Object)normalizedValue);
            }
            String key = optionParts[0].trim();
            String normalizedKey = SettingOptions.normalize(key);
            optionsMap.addOption(normalizedKey, new Option(normalizedKey, value));
            ++n2;
        }
    }

    public static OptionsMap createOptionsMap(@Nullable String optionsString, @Nullable OptionsExpr initOptionsExpr, IID iid) {
        OptionsMap newMap = SettingUtils.createOptionsMap(optionsString, iid);
        if (initOptionsExpr != null) {
            for (Option option : initOptionsExpr.getOptions()) {
                String optionId = SettingOptions.normalize(option.getId());
                if (newMap.isOptionSet(optionId) && SWToolsProperties.isVerificationOn()) {
                    LOGGER.log(Level.WARNING, () -> MessageFormat.format("[DATA] Option {0} in setting with ID \"{1}\" already exists and it will be overwritten by option specified in <{2}>", optionId, iid.getId(), "options_expr"));
                }
                newMap.addOption(optionId, option);
            }
        }
        return newMap;
    }
}

