/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.documentation;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.data.ComponentLoadingStatus;
import com.nxp.swtools.resourcetables.model.data.documentation.ISectionsProvider;
import com.nxp.swtools.resourcetables.model.data.documentation.Section;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="contents", strict=false)
public class Contents
implements ISectionsProvider {
    @ElementList(inline=true, required=false)
    private List<Section> sections = new ArrayList<Section>();
    private static final Logger LOGGER = LogManager.getLogger(Contents.class);

    public static @Nullable Contents loadContent(File source) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = UtilsDecryption.getFileInputStream((File)source);){
                Persister serializer = new Persister();
                return (Contents)serializer.read(Contents.class, inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] [MENU_CONTENTS] [{0}] Error loading menu contents file {1}", ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), source.getAbsolutePath()), e);
            return null;
        }
    }

    @Override
    public List<Section> getSections() {
        return CollectionsUtils.unmodifiableList(this.sections);
    }

    @Override
    public boolean hasSubSections() {
        return !this.sections.isEmpty();
    }
}

