/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="item_defaults", strict=false)
public class ItemDefaults {
    private LinkedHashMap<String, SetDefault> setDefaults = new LinkedHashMap();

    @ElementList(type=SetDefault.class, required=false, inline=true)
    private @ElementList(type=SetDefault.class, required=false, inline=true) List<SetDefault> getDefaultsList() {
        return CollectionsUtils.listFromMapValues(this.setDefaults);
    }

    @ElementList(type=SetDefault.class, required=false, inline=true)
    protected void setDefaultsList(List<SetDefault> newDefaults) {
        this.setDefaults.clear();
        newDefaults.stream().forEachOrdered(item -> {
            SetDefault setDefault = this.setDefaults.put(item.getId(), (SetDefault)item);
        });
    }

    public Map<String, SetDefault> getDefaults() {
        return this.setDefaults;
    }

    public void addDefault(SetDefault setDefault) {
        this.setDefaults.put(setDefault.getId(), setDefault);
    }

    public @Nullable SetDefault getDefault(String setDefaultId) {
        return this.setDefaults.get(setDefaultId);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [setDefaults=" + this.setDefaults + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.setDefaults.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemDefaults other = (ItemDefaults)obj;
        return this.setDefaults.equals(other.setDefaults);
    }

    @Root(name="set_default", strict=false)
    public static class SetDefault
    implements IID {
        @Attribute(name="id", required=false)
        @Nullable
        private @Attribute(name="id", required=false) @Nullable String id;
        @Nullable
        private Expression valueExpr;

        @Attribute(name="value_expr", required=true)
        public @Attribute(name="value_expr", required=true) @Nullable String getValue() {
            return this.valueExpr != null ? this.valueExpr.formatOutput(FormatOptions.DEFAULT) : null;
        }

        public @Nullable Expression getValueExpr() {
            return this.valueExpr;
        }

        @Attribute(name="value_expr", required=true)
        private void setValue(String newValue) {
            if (!newValue.isEmpty()) {
                try {
                    this.valueExpr = Expression.create((String)newValue);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Set default with id \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
                }
            }
        }

        public SetDefault(@Nullable String id, String value) {
            this.id = id;
            if (!value.isEmpty()) {
                this.valueExpr = Expression.tryCreate((String)value);
            }
        }

        @Deprecated
        protected SetDefault() {
            this(null, "");
        }

        @Override
        public String getId() {
            return UtilsText.safeString((String)this.id);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "id" + "=" + this.getId() + ", " + "value_expr" + "=" + UtilsText.safeString((String)this.getValue());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.id);
            result = 31 * result + Objects.hashCode(this.valueExpr);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetDefault other = (SetDefault)obj;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            return Objects.equals(this.valueExpr, other.valueExpr);
        }
    }
}

