/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.table;

import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.ResourceTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InterruptResourceTable {
    private static final String CID_DEVICES = "devices";
    private static final String CID_ID = "id";
    private ResourceTable resourceTable;
    private Collection<ISettingConfig> settingConfigs;
    private Map<String, Map<String, Set<String>>> intsByPeriphByCore = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Map<String, Set<String>>> periphsByIntByCore = new HashMap<String, Map<String, Set<String>>>();
    private List<String> cores = new ArrayList<String>();

    public InterruptResourceTable(ResourceTable resourceTable, Collection<ISettingConfig> settingConfigs) {
        this.resourceTable = resourceTable;
        this.settingConfigs = settingConfigs;
    }

    public List<String> findInterruptNames(String periphId, String coreId) {
        ArrayList<String> result = new ArrayList<String>();
        for (ISettingConfig coreArray : this.settingConfigs) {
            Set ints;
            if (!coreArray.getId().equals(coreId)) continue;
            Map intsByPeriph = this.intsByPeriphByCore.getOrDefault(coreId, new HashMap());
            this.intsByPeriphByCore.putIfAbsent(coreId, intsByPeriph);
            if (intsByPeriph.isEmpty()) {
                InterruptResourceTable.initIntsByPeriph(intsByPeriph, (ArrayConfig)coreArray);
            }
            if ((ints = (Set)intsByPeriph.get(periphId)) == null) continue;
            result.addAll(ints);
        }
        return result;
    }

    public List<String> findPeripheralNames(String intId, String coreId) {
        ArrayList<String> result = new ArrayList<String>();
        for (ISettingConfig coreArray : this.settingConfigs) {
            Set periphs;
            if (!coreArray.getId().equals(coreId)) continue;
            Map periphsByInt = this.periphsByIntByCore.getOrDefault(coreId, new HashMap());
            this.periphsByIntByCore.putIfAbsent(coreId, periphsByInt);
            if (periphsByInt.isEmpty()) {
                InterruptResourceTable.initPeriphsByInt(periphsByInt, (ArrayConfig)coreArray);
            }
            if ((periphs = (Set)periphsByInt.get(intId)) == null) continue;
            result.addAll(periphs);
        }
        return result;
    }

    public List<String> getInterruptNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ISettingConfig coreArray : this.settingConfigs) {
            String coreId = coreArray.getId();
            Map periphsByInt = this.periphsByIntByCore.getOrDefault(coreId, new HashMap());
            this.periphsByIntByCore.putIfAbsent(coreId, periphsByInt);
            if (periphsByInt.isEmpty()) {
                InterruptResourceTable.initPeriphsByInt(periphsByInt, (ArrayConfig)coreArray);
            }
            result.addAll(periphsByInt.keySet());
        }
        return result;
    }

    public List<String> getPeripheralNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ISettingConfig coreArray : this.settingConfigs) {
            String coreId = coreArray.getId();
            Map intsByPeriph = this.intsByPeriphByCore.getOrDefault(coreId, new HashMap());
            this.intsByPeriphByCore.putIfAbsent(coreId, intsByPeriph);
            if (intsByPeriph.isEmpty()) {
                InterruptResourceTable.initIntsByPeriph(intsByPeriph, (ArrayConfig)coreArray);
            }
            result.addAll(intsByPeriph.keySet());
        }
        return result;
    }

    private static void initIntsByPeriph(Map<String, Set<String>> intsByPeriph, ArrayConfig coreArray) {
        for (ISettingConfig irqIndexChild : coreArray.getChildren()) {
            StructConfig irqIndexStruct = (StructConfig)irqIndexChild;
            IChild irqId = irqIndexStruct.getChildById(CID_ID);
            if (irqId == null) continue;
            String interrupt = irqId.getValue().toString();
            ArrayConfig devicesArray = (ArrayConfig)irqIndexStruct.getChildById(CID_DEVICES);
            if (devicesArray == null) continue;
            for (ISettingConfig deviceIndexChild : devicesArray.getChildren()) {
                StructConfig deviceIndexStruct = (StructConfig)deviceIndexChild;
                IChild periphId = deviceIndexStruct.getChildById(CID_ID);
                if (periphId == null) continue;
                String periph = periphId.getValue().toString();
                Set ints = intsByPeriph.getOrDefault(periph, new HashSet());
                intsByPeriph.putIfAbsent(periph, ints);
                ints.add(interrupt);
            }
        }
    }

    private static void initPeriphsByInt(Map<String, Set<String>> periphsByInt, ArrayConfig coreArray) {
        for (ISettingConfig irqIndexChild : coreArray.getChildren()) {
            StructConfig irqIndexStruct = (StructConfig)irqIndexChild;
            IChild irqId = irqIndexStruct.getChildById(CID_ID);
            if (irqId == null) continue;
            String interrupt = irqId.getValue().toString();
            Set periphs = periphsByInt.getOrDefault(interrupt, new HashSet());
            ArrayConfig devicesArray = (ArrayConfig)irqIndexStruct.getChildById(CID_DEVICES);
            if (devicesArray != null) {
                for (ISettingConfig deviceIndexChild : devicesArray.getChildren()) {
                    StructConfig deviceIndexStruct = (StructConfig)deviceIndexChild;
                    IChild periphId = deviceIndexStruct.getChildById(CID_ID);
                    if (periphId == null) continue;
                    periphs.add(periphId.getValue().toString());
                }
            }
            periphsByInt.put(interrupt, periphs);
        }
    }

    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    public Collection<ISettingConfig> getSettingConfigs() {
        return this.settingConfigs;
    }

    public Collection<String> getCores() {
        if (this.cores.isEmpty()) {
            for (ISettingConfig coreArray : this.settingConfigs) {
                this.cores.add(coreArray.getId());
            }
        }
        return this.cores;
    }
}

