/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.diab.mbs;

import com.nxp.s32ds.cle.diab.mbs.Activator;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;

public class TargetOptionValueHandler
extends ManagedOptionValueHandler {
    static final String OPTION = ".option";
    static final String ASSEMBLER = ".assembler";
    static final String C_COMPILER = ".c.compiler";
    static final String CPP_COMPILER = ".cpp.compiler";
    static final String C_LINKER = ".c.linker";
    static final String CPP_LINKER = ".cpp.linker";
    static final String DISASSEMBLER = ".disassembler";
    static final String TARGET_OPTION = "-t";

    public boolean handleValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        if (event == 4 || event == 1) {
            String objValue;
            IOption srcOption;
            String optionBaseId;
            ITool[] tools;
            IConfiguration config;
            block9: {
                config = null;
                tools = null;
                if (configuration instanceof IConfiguration) {
                    config = (IConfiguration)configuration;
                    tools = config.getTools();
                } else if (configuration instanceof IFolderInfo) {
                    IFolderInfo oFolderInfo = (IFolderInfo)configuration;
                    config = oFolderInfo.getParent();
                    tools = oFolderInfo.getTools();
                }
                if (config == null) {
                    return false;
                }
                IToolChain toolChain = config.getToolChain();
                optionBaseId = option.getBaseId();
                srcOption = toolChain.getOptionBySuperClassId(optionBaseId);
                objValue = null;
                if (srcOption.getBasicValueType() == 2) break block9;
                return false;
            }
            try {
                objValue = srcOption.getStringValue();
                String optionName = optionBaseId.substring(optionBaseId.indexOf(OPTION) + OPTION.length(), optionBaseId.length());
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    TargetOptionValueHandler.setOption(config, objValue, tool, tool.getBaseId(), optionName);
                    ++n2;
                }
                return true;
            }
            catch (BuildException e) {
                Activator.logWarning(e.getMessage());
            }
        }
        return false;
    }

    public static void setOption(IConfiguration config, Object objValue, ITool tool, String dstOptionId, String optionName) throws BuildException {
        ITool toolBase = tool.getSuperClass();
        if (toolBase == null) {
            return;
        }
        String toolBaseId = toolBase.getId();
        if (toolBaseId == null) {
            return;
        }
        if (toolBaseId.contains(ASSEMBLER) || toolBaseId.contains(C_COMPILER) || toolBaseId.contains(CPP_COMPILER) || toolBaseId.contains(C_LINKER) || toolBaseId.contains(CPP_LINKER)) {
            StringBuilder dstOptionValueId = new StringBuilder(toolBaseId.toString());
            dstOptionValueId.append(OPTION + optionName);
            IOption dstOption = tool.getOptionBySuperClassId(dstOptionValueId.toString());
            if (dstOption == null) {
                return;
            }
            if (dstOption.getBasicValueType() == 2) {
                StringBuilder sourceValue = new StringBuilder(TARGET_OPTION + (String)objValue);
                config.setOption((IHoldsOptions)tool, dstOption, sourceValue.toString());
            }
        }
    }
}

