/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.zephyrrtos;

import com.nxp.s32ds.tad.common.AbstractCommonActivator;
import com.nxp.s32ds.tad.common.logger.Logger;
import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.zephyrrtos.model.ZephyrTadModel;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class Activator
extends AbstractCommonActivator {
    public static final String PLUGIN_ID = "com.nxp.s32ds.tad.zephyrrtos";
    public static final String IMG_ZEPHYR = "com.nxp.s32ds.tad.zephyrrtos.image.zephyr";
    public static final String IMG_TERMINATE = "com.nxp.s32ds.tad.zephyrrtos.image.terminate";
    public static final String IMG_STATE_RUNNING = "com.nxp.s32ds.tad.zephyrrtos.image.running";
    public static final String IMG_STATE_DUMMY = "com.nxp.s32ds.tad.zephyrrtos.image.dummy";
    public static final String IMG_STATE_PENDING = "com.nxp.s32ds.tad.zephyrrtos.image.pending";
    public static final String IMG_STATE_PRESTART = "com.nxp.s32ds.tad.zephyrrtos.image.prestart";
    public static final String IMG_STATE_DEAD = "com.nxp.s32ds.tad.zephyrrtos.image.dead";
    public static final String IMG_STATE_SUSPENDED = "com.nxp.s32ds.tad.zephyrrtos.image.suspended";
    public static final String IMG_STATE_ABORTING = "com.nxp.s32ds.tad.zephyrrtos.image.aborting";
    public static final String IMG_STATE_QUEUED = "com.nxp.s32ds.tad.zephyrrtos.image.queued";
    public static final String IMG_STATE_UNKNOWN = "com.nxp.s32ds.tad.zephyrrtos.image.unknown";
    public static final String IMG_INIT_STACKS = "com.nxp.s32ds.tad.zephyrrtos.image.init_stacks.enabled";
    public static final String PLUGIN_ID_DEBUG_UI = "org.eclipse.debug.ui";
    public static final String PLUGIN_ID_UI_BROWSER = "org.eclipse.ui.browser";
    public static final String PLUGIN_ID_UI_IDE = "org.eclipse.ui.ide";
    public static final String PLUGIN_ID_EGIT_UI = "org.eclipse.egit.ui";
    public static final String PLUGIN_ID_HELP_UI = "org.eclipse.help.ui";
    public static final String PLUGIN_ID_CDT_UI = "org.eclipse.cdt.ui";
    public static final String BAD_WHITE_SPACE_MATCH = "\\s(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)";
    public static final String NEWLINE_MATCH = "\\\\n";
    private static Activator plugin;
    private ZephyrTadModel tadModel;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.tadModel = new ZephyrTadModel();
    }

    public void post_start(BundleContext context) throws Exception {
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String imgID) {
        return this.getImageRegistry().getDescriptor(imgID);
    }

    protected void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        this.registerImage(reg, IMG_ZEPHYR, "zephyr.png");
        super.registerImage(reg, IMG_TERMINATE, PLUGIN_ID_DEBUG_UI, "full/elcl16/terminate_co.png");
        super.registerImage(reg, IMG_STATE_RUNNING, PLUGIN_ID_UI_BROWSER, "elcl16/nav_go.png");
        super.registerImage(reg, IMG_STATE_DUMMY, PLUGIN_ID_DEBUG_UI, "full/elcl16/disabled_co.png");
        super.registerImage(reg, IMG_STATE_PENDING, PLUGIN_ID_UI_IDE, "full/elcl16/configs.png");
        super.registerImage(reg, IMG_STATE_PRESTART, PLUGIN_ID_EGIT_UI, "elcl16/continue.png");
        super.registerImage(reg, IMG_STATE_DEAD, PLUGIN_ID_EGIT_UI, "obj16/done_step.png");
        super.registerImage(reg, IMG_STATE_SUSPENDED, PLUGIN_ID_DEBUG_UI, "full/elcl16/suspend_co.png");
        super.registerImage(reg, IMG_STATE_ABORTING, PLUGIN_ID_DEBUG_UI, "full/elcl16/rem_co.png");
        super.registerImage(reg, IMG_STATE_QUEUED, PLUGIN_ID_HELP_UI, "elcl16/showcat_co.png");
        super.registerImage(reg, IMG_STATE_UNKNOWN, PLUGIN_ID_CDT_UI, "obj16/unknown_type_obj.gif");
        super.registerImage(reg, IMG_INIT_STACKS, PLUGIN_ID_CDT_UI, "obj16/define_obj.gif");
    }

    public TadModel getTadModel() {
        return this.tadModel;
    }

    public Logger getLogger() {
        return this.getTadModel().getLogger();
    }

    public String getVersionAsString() {
        Bundle BUNDLE = Activator.getDefault().getBundle();
        if (BUNDLE != null) {
            Version v = BUNDLE.getVersion();
            return String.format("%d.%d.%d (%s)", v.getMajor(), v.getMinor(), v.getMicro(), v.getQualifier());
        }
        return Messages.Error_Unknown;
    }
}

