/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.zephyrrtos.model.zephyr;

import com.nxp.s32ds.tad.common.rtos.IRtosConfig;
import com.nxp.s32ds.tad.common.rtos.Rtos;
import com.nxp.s32ds.tad.common.rtos.RtosAvailability;
import com.nxp.s32ds.tad.zephyrrtos.Activator;
import com.nxp.s32ds.tad.zephyrrtos.Messages;
import com.nxp.s32ds.tad.zephyrrtos.model.zephyr.ZephyrRTOSConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

public class ZephyrRTOS
extends Rtos {
    public static final String CONFIG_MACROS_FILE = ".config";
    public static final String CONFIG_MACRO_ENABLED_VALUE = "y";
    public static final String KERNEL_VAR = "_kernel";
    public static final String KERNEL_STRUCT = "z_kernel";
    public static final String KERNEL_STRUCT_FIELD_THREADS = "threads";
    public static final String KERNEL_STRUCT_FIELD_CPUS = "cpus";
    public static final String CPU_STRUCT = "_cpu";
    public static final String CPU_STRUCT_FIELD_CURRENT = "current";
    public static final String THREAD_STRUCT = "k_thread";
    public static final String THREAD_STRUCT_FIELD_BASE = "base";
    public static final String THREAD_STRUCT_FIELD_ENTRY = "entry";
    public static final String THREAD_STRUCT_FIELD_NEXT_THREAD = "next_thread";
    public static final String THREAD_STRUCT_FIELD_NAME = "name";
    public static final String THREAD_STRUCT_FIELD_STACK_INFO = "stack_info";
    public static final String THREAD_STRUCT_FIELD_CALLEE_SAVED = "callee_saved";
    public static final String THREAD_BASE_STRUCT = "_thread_base";
    public static final String THREAD_BASE_STRUCT_FIELD_USER_OPTIONS = "user_options";
    public static final String THREAD_BASE_STRUCT_FIELD_STATE = "thread_state";
    public static final String THREAD_BASE_STRUCT_FIELD_PRIORITY = "prio";
    public static final String THREAD_STACK_INFO_STRUCT = "_thread_stack_info";
    public static final String THREAD_STACK_INFO_STRUCT_FIELD_START = "start";
    public static final String THREAD_STACK_INFO_STRUCT_FIELD_SIZE = "size";
    public static final String THREAD_STACK_INFO_STRUCT_FIELD_DELTA = "delta";
    public static final String THREAD_ENTRY_STRUCT = "__thread_entry";
    public static final String THREAD_ENTRY_STRUCT_FIELD_ENTRY = "pEntry";
    public static final String THREAD_ENTRY_STRUCT_FIELD_P1 = "parameter1";
    public static final String THREAD_ENTRY_STRUCT_FIELD_P2 = "parameter2";
    public static final String THREAD_ENTRY_STRUCT_FIELD_P3 = "parameter3";
    public static final String THREAD_CALLEE_SAVED_STRUCT = "_callee_saved";
    public static final String THREAD_CALLEE_SAVED_STRUCT_FIELD_PSP = "sp_elx";

    public void setAvailability(RtosAvailability availability) {
        if (availability != RtosAvailability.AVAILABLE) {
            Activator.getDefault().getLogger().info(Messages.Info_ZephyrNotUsed);
        }
        super.setAvailability(availability);
    }

    public void init() {
        super.init();
        this.config.put(ZephyrRTOSConfig.THREAD_MONITOR, true);
        this.config.put(ZephyrRTOSConfig.THREAD_NAME, true);
        this.config.put(ZephyrRTOSConfig.STACK_INFO, true);
        this.config.put(ZephyrRTOSConfig.INIT_STACKS, false);
    }

    public void initStructs(double version) {
        this.structs.clear();
        this.version = version;
        this.structs.put(KERNEL_STRUCT, KERNEL_STRUCT);
        this.structs.put(CPU_STRUCT, CPU_STRUCT);
        this.structs.put(THREAD_STRUCT, THREAD_STRUCT);
        this.structs.put(THREAD_BASE_STRUCT, THREAD_BASE_STRUCT);
        this.structs.put(THREAD_STACK_INFO_STRUCT, THREAD_STACK_INFO_STRUCT);
        this.structs.put(THREAD_ENTRY_STRUCT, THREAD_ENTRY_STRUCT);
        this.structs.put(THREAD_CALLEE_SAVED_STRUCT, THREAD_CALLEE_SAVED_STRUCT);
    }

    public void enableMacro(IRtosConfig macro, boolean enable) {
        if (!enable) {
            Activator.getDefault().getLogger().info(String.format(com.nxp.s32ds.tad.common.messages.Messages.Info_MacroDisabled, macro.toString()));
        }
        this.config.put(macro, enable);
    }

    public void loadConfigMacros(DsfSession session) {
        ILaunch launch = (ILaunch)session.getModelAdapter(ILaunch.class);
        if (launch != null) {
            ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
            if (launchConfig != null) {
                try {
                    ICProject project = CDebugUtils.getCProject((ILaunchConfiguration)launchConfig);
                    IPath filePath = LaunchUtils.verifyProgramPath((ILaunchConfiguration)launchConfig, (ICProject)project);
                    String folder = filePath.makeAbsolute().toFile().getParent();
                    String propsFilePath = String.valueOf(folder) + File.separator + CONFIG_MACROS_FILE;
                    Properties zephyrProps = new Properties();
                    try {
                        Throwable throwable = null;
                        Object var10_13 = null;
                        try (FileInputStream configInputStream = new FileInputStream(propsFilePath);){
                            zephyrProps.load(configInputStream);
                            Stream.of(ZephyrRTOSConfig.values()).forEach(zephyrConfig -> {
                                String enabledStr = zephyrProps.getProperty(zephyrConfig.toString());
                                this.enableMacro((IRtosConfig)zephyrConfig, enabledStr != null && CONFIG_MACRO_ENABLED_VALUE.equals(enabledStr.toLowerCase()));
                            });
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        Activator.getDefault().getLogger().info(NLS.bind((String)Messages.Log_DotConfigNotRead, (Object)e.getMessage()));
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().getLogger().info(NLS.bind((String)Messages.Log_DotConfigNotRead, (Object)e.getMessage()));
                }
            } else {
                Activator.getDefault().getLogger().info(NLS.bind((String)Messages.Log_DotConfigNotRead, (Object)Messages.Log_DotConfigNotReadInvalidLaunchConfig));
            }
        } else {
            Activator.getDefault().getLogger().info(NLS.bind((String)Messages.Log_DotConfigNotRead, (Object)Messages.Log_DotConfigNotReadInvalidLaunch));
        }
    }
}

