/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.mcu;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Mcu
implements IMcu {
    private final IMcuIdentification mcuIdentification;
    private final Collection<@NonNull ProcessorCore> cores;
    private final IProcessorMasterToolInfo masterToolInfo;
    private List<ABaseUIComponentSetting> allGuiComponentSettings = new ArrayList<ABaseUIComponentSetting>();

    public Mcu(IMcuIdentification mcuIdentification, IProcessorMasterToolInfo masterToolInfo, Collection<ProcessorCore> cores) {
        this.mcuIdentification = mcuIdentification;
        this.masterToolInfo = masterToolInfo;
        this.cores = cores;
    }

    public @NonNull String getPartNumber() {
        return this.mcuIdentification.getMcu();
    }

    public @NonNull String getSeries() {
        return this.masterToolInfo.getSeries();
    }

    public @NonNull String getFamily() {
        return this.masterToolInfo.getFamily();
    }

    public @NonNull String getDataVersion() {
        return this.masterToolInfo.getVersion();
    }

    public @NonNull String getPackage() {
        return this.mcuIdentification.getPackage();
    }

    public @NonNull String getSdkVersion() {
        return this.mcuIdentification.getSdkVersion();
    }

    public @Nullable String getBoard() {
        return this.mcuIdentification.getBoard();
    }

    public @Nullable String getKit() {
        return this.mcuIdentification.getKit();
    }

    public @NonNull JSONObject getCoresList() {
        JSONObject res = new JSONObject();
        for (ProcessorCore oneCore : this.cores) {
            JSONObject core = new JSONObject();
            try {
                core.put("core", (Object)oneCore.getName());
                core.put("id", (Object)oneCore.getID());
                core.put("description", (Object)oneCore.getDescription());
                core.put("enabled", true);
                res.put(oneCore.getID(), (Object)core);
            }
            catch (JSONException e) {
                assert (false) : e.getMessage();
            }
        }
        return res;
    }

    @Override
    public @NonNull IMcuIdentification getMcuIdentification() {
        return this.mcuIdentification;
    }

    @Override
    public @NonNull Collection<@NonNull ProcessorCore> getCores() {
        return this.cores;
    }

    public @Nullable String getMexVariant() {
        return this.mcuIdentification.getMexVariant();
    }

    @Override
    public List<ABaseUIComponentSetting> getAllGuiComponentSettings() {
        return this.allGuiComponentSettings;
    }
}

