/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.validation;

import com.nxp.swtools.common.uct.utils.Messages;
import com.nxp.swtools.common.uct.validation.ATextfieldWidthValidator;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Status;

public class BinaryAddressValidator
extends ATextfieldWidthValidator {
    protected static final Logger LOGGER = LogManager.getLogger(BinaryAddressValidator.class);
    protected boolean formatValid = true;

    public BinaryAddressValidator(int width) {
        super(width);
    }

    @Override
    public Status validate(String pluginId, String value) {
        return this.isValidBinary(pluginId, value);
    }

    public Status isValidBinary(String pluginId, String value) {
        Status status = new Status(0, pluginId, "");
        if (NumberFormatValidator.isValidBinary((String)value)) {
            this.formatValid = true;
            if (!NumberFormatValidator.isValidBinary((String)value) || value.length() != this.getWidth()) {
                status = new Status(4, pluginId, MessageFormat.format(Messages.BinaryInvalidWidthValue, String.valueOf(value.length()), String.valueOf(this.getWidth())));
            } else {
                try {
                    Long.parseLong(value, 2);
                }
                catch (NumberFormatException err) {
                    LOGGER.log(Level.WARNING, "Error parsing ", err);
                    status = new Status(4, pluginId, Messages.InvalidWidthValue);
                }
            }
        } else {
            status = new Status(4, pluginId, Messages.BinaryInvalidValue);
            this.formatValid = false;
        }
        return status;
    }

    @Override
    public boolean isFormatValid() {
        return this.formatValid;
    }
}

