/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.ddr.controller.DDRController;
import com.nxp.swtools.ddr.model.DDRDataModel;
import com.nxp.swtools.mem.validation.integration.ddr.MemValDDRConfigProvider;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;

public class MemValDDRServiceProvider
extends AbstractSourceProvider {
    public static final String DDR_COMPONENT_LOCKED = "com.nxp.swtools.mem.validation.integration.ddr.isComponentLocked";
    public static final String IMPORT_FROM_TARGET_AVAILABLE = "com.nxp.swtools.mem.validation.integration.ddr.isImportFromTargetAvailable";
    private static final String IMPORT_FROM_TARGET_CUSTOM_OPTION = "importFromTargetAvailable";
    @Nullable
    private static VModel vModel;
    MemValDDRConfigProvider configProvider = new MemValDDRConfigProvider();

    public MemValDDRServiceProvider() {
        DDRController.getInstance().addListener(129, event -> this.updateState());
        DDRController.getInstance().addListener(8, event -> this.resetModel());
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(DDR_COMPONENT_LOCKED, MemValDDRServiceProvider.isDDRComponentLocked());
        map.put(IMPORT_FROM_TARGET_AVAILABLE, this.isImportFromTargetAvailable());
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{DDR_COMPONENT_LOCKED, IMPORT_FROM_TARGET_AVAILABLE};
    }

    public void updateState() {
        this.fireSourceChanged(0, this.getCurrentState());
    }

    public void resetModel() {
        vModel = null;
    }

    public void dispose() {
    }

    private static boolean isDDRComponentLocked() {
        DDRController ddrController = DDRController.getInstance();
        DDRDataModel ddrDataModel = ddrController.getDataModel();
        CollectionsUtils.Pair currentComponent = ddrDataModel.getCurrentComponent();
        if (currentComponent != null) {
            return ((IComponentInstanceConfig)currentComponent.getSecond()).isEditingLocked();
        }
        return false;
    }

    private boolean isImportFromTargetAvailable() {
        if (vModel == null) {
            vModel = this.configProvider.getVModel();
        }
        if (vModel != null) {
            String option = vModel.getCustomOption(IMPORT_FROM_TARGET_CUSTOM_OPTION);
            if (option != null) {
                return option.equals("true");
            }
            return false;
        }
        return false;
    }
}

