/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.core;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.cle.uct.core.ProjectUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ProjectContextHelper {
    private IProject project;
    private ProjectContextSettings context;
    private static final String REXP_HWM_CORE_NAME = "cortex\\S*?(\\w+)";
    private static final String REXP_HWM_CORE_INDEX = "_(\\d{0,1}_*\\d{0,1})(_.*)*$";
    private static final String REXP_CORE_INDEX = "core(\\d{1})";
    private static final Logger LOGGER = LogManager.getLogger(ProjectContextHelper.class);

    public ProjectContextHelper(IProject project) {
        this.project = project;
        this.context = new ProjectContextSettings(project);
    }

    public String getCoreId(Collection<ProcessorCore> cores) {
        ProcessorCore core;
        int index;
        if (cores == null) {
            LOGGER.log(Level.INFO, "Cannot detect the core id, user will choose it");
            return null;
        }
        String deviceCoreId = this.context.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        String hwCoreIndex = ProjectContextHelper.getCoreIndex(deviceCoreId, REXP_HWM_CORE_INDEX);
        String hwCoreName = hwCoreIndex == null ? deviceCoreId.substring(deviceCoreId.indexOf("_") + 1) : ProjectUtils.getStringByRegx(this.context.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.core.id"), REXP_HWM_CORE_NAME);
        String hwCoreIndexInBinary = null;
        try {
            if (hwCoreIndex != null) {
                hwCoreIndexInBinary = Integer.toString(Integer.parseInt(hwCoreIndex, 2));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        ArrayList<ProcessorCore> coresList = new ArrayList<ProcessorCore>();
        for (ProcessorCore core2 : cores) {
            String coreName = ProjectUtils.getStringByRegx(core2.getName(), REXP_HWM_CORE_NAME);
            if (hwCoreName == null || !hwCoreName.equalsIgnoreCase(coreName)) continue;
            if (hwCoreIndex == null || hwCoreIndex.equalsIgnoreCase(ProjectContextHelper.getCoreIndex(core2.getID(), REXP_HWM_CORE_INDEX))) {
                return core2.getID();
            }
            String coreIndex = ProjectContextHelper.getCoreIndex(core2.getID(), REXP_CORE_INDEX);
            if (coreIndex != null) {
                if (coreIndex.equalsIgnoreCase(hwCoreIndex)) {
                    return core2.getID();
                }
                if (coreIndex.equalsIgnoreCase(hwCoreIndexInBinary)) {
                    return core2.getID();
                }
            }
            coresList.add(core2);
        }
        if (hwCoreIndex != null && (index = Integer.parseInt(hwCoreIndex)) < coresList.size() && (core = (ProcessorCore)coresList.get(index)) != null) {
            return core.getID();
        }
        return null;
    }

    private static String getCoreIndex(String core, String rexp) {
        String c = ProjectUtils.getStringByRegx(core, rexp);
        if (c == null) {
            return null;
        }
        if (c.contains("_")) {
            return c.replaceFirst("_", "");
        }
        return c;
    }

    public SdkDescriptor getSDK() {
        SdkDescriptor sdk = null;
        List sdksAttached = SdkAttachDataHelper.getSdksAttachedToProject((IProject)this.project, (boolean)false);
        List sdksAll = SdkManagementUtils.getFilteredSdks(xsdk -> true);
        ISharedConfiguration cfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
        String cfgProcessor = cfg.getCommonConfig().getMcuIdentification().getMcu();
        String cfgSdkVersion = cfg.getCommonConfig().getSdkVersion();
        String prjProcessor = this.getProcessor();
        sdk = !sdksAttached.isEmpty() && !cfg.isEmpty() && cfgProcessor.equalsIgnoreCase(prjProcessor) ? this.findSdk(sdksAttached, cfgProcessor, cfgSdkVersion) : (!sdksAttached.isEmpty() && cfg.isEmpty() ? this.findSdk(sdksAttached) : (sdksAttached.isEmpty() && !cfg.isEmpty() && cfgProcessor.equalsIgnoreCase(prjProcessor) ? this.findSdk(sdksAll, cfgProcessor, cfgSdkVersion) : this.findSdk(sdksAll)));
        return sdk;
    }

    private SdkDescriptor findSdk(List<SdkDescriptor> sdks, String proc, String ver) {
        for (SdkDescriptor sdk : sdks) {
            String sdkId = sdk.getExternalId();
            if (!ver.equals(sdkId)) continue;
            return sdk;
        }
        return null;
    }

    private SdkDescriptor findSdk(List<SdkDescriptor> sdks) {
        String deviceId = this.getProjectSaverValue("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        String deviceCoreId = this.getProjectSaverValue("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        String deviceRevisionId = this.getProjectSaverValue("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
        if (deviceCoreId.isEmpty() || deviceId.isEmpty()) {
            return null;
        }
        List filteredList = sdks.stream().filter(sdk -> {
            if (sdk.getTags().contains("uct")) {
                Map descriptors = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)sdk.getId());
                Set sdkDeviceCoreId = (Set)descriptors.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
                return sdkDeviceCoreId != null && sdkDeviceCoreId.contains(deviceCoreId);
            }
            return false;
        }).collect(Collectors.toList());
        Optional<Object> sdk2 = filteredList.stream().filter(s -> {
            Map descriptors = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)s.getId());
            Set sdkDeviceRevId = (Set)descriptors.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
            return sdkDeviceRevId != null && sdkDeviceRevId.contains(deviceRevisionId);
        }).max((s1, s2) -> s1.getVersion().compareTo(s2.getVersion()));
        if (sdk2.isPresent()) {
            return sdk2.get();
        }
        sdk2 = filteredList.stream().findFirst();
        if (sdk2.isPresent()) {
            return (SdkDescriptor)sdk2.get();
        }
        sdk2 = sdks.stream().filter(p -> p.getName().matches(deviceCoreId) || p.getName().contains(deviceId)).findFirst();
        if (sdk2.isPresent()) {
            return (SdkDescriptor)sdk2.get();
        }
        return null;
    }

    private String getProjectSaverValue(String key) {
        return this.context.getAttributeByKey(key);
    }

    public String getProcessor() {
        String device = this.getProjectSaverValue("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        String revision = this.getProjectSaverValue("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
        return ProjectUtils.join(device, revision);
    }

    public String getCoreType() {
        return this.context.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
    }

    public String getToolchainName() {
        IToolChain toolchain = this.getToolchain();
        if (toolchain != null) {
            return toolchain.getName();
        }
        return null;
    }

    public String getToolchainId() {
        IToolChain toolchain = this.getToolchain();
        if (toolchain != null) {
            return toolchain.getId();
        }
        return null;
    }

    private IToolChain getToolchain() {
        IConfiguration[] iConfigurationArray;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project, (boolean)true);
        if (info != null && (iConfigurationArray = info.getManagedProject().getConfigurations()).length != 0) {
            IConfiguration config = iConfigurationArray[0];
            return config.getToolChain();
        }
        return null;
    }
}

