/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.providers;

import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OptionValueHolder {
    public static final String DEFAULT_CONFIG = "com.nxp.s32ds.default.config";
    private Map<String, Set<String>> values = new LinkedHashMap<String, Set<String>>();

    public OptionValueHolder(OptionValueHolder value) {
        for (String config : value.getConfigs()) {
            LinkedHashSet<String> newSet = new LinkedHashSet<String>();
            this.values.put(config, newSet);
            SDKManifestProvider.merge(newSet, value.getValues(config));
        }
    }

    public OptionValueHolder() {
        LinkedHashSet newSet = new LinkedHashSet();
        this.values.put(DEFAULT_CONFIG, newSet);
    }

    public Set<String> getConfigs() {
        return this.values.keySet();
    }

    public Set<String> getValues(String configId) {
        if (configId != null) {
            for (String key : this.values.keySet()) {
                if (!key.equals(configId) && !configId.endsWith(key)) continue;
                Set<String> set = this.values.get(key);
                set.addAll((Collection<String>)this.values.get(DEFAULT_CONFIG));
                return set;
            }
        }
        return this.values.get(DEFAULT_CONFIG);
    }

    public void add(String value) {
        this.getValues().add(value);
    }

    public void clear() {
        this.getValues().clear();
    }

    private Set<String> getValues() {
        return this.getValues(DEFAULT_CONFIG);
    }

    public boolean contains(String value) {
        return this.getValues().contains(value);
    }

    public boolean isEmpty() {
        return this.getValues().isEmpty();
    }

    public boolean isSingle() {
        return this.values.keySet().size() <= 1;
    }

    public String toString() {
        return this.values.toString();
    }

    public Set<String> addConfig(String configId) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        this.values.put(configId, set);
        return set;
    }
}

