/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.scripting;

import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.internal.core.ToolchainSettingsUtils;
import com.nxp.swtools.periphs.controller.scripting.PeripheralsScriptProfile;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;

public class ToolchainScriptProfile
extends PeripheralsScriptProfile {
    private ToolchainSettingsUtils toolchainUtils;
    private ICProjectDescription projectDescription;
    public static final String STORAGE_ID = "com.nxp.s32ds.cle.uct.internal.core.toolchainScriptProfile";
    private Map<String, Set<String>> toolchainComponents = new HashMap<String, Set<String>>();

    public ToolchainScriptProfile(IMcu mcu, PeriphsProfile profile, ICProjectDescription projectDescription) {
        super(mcu, profile);
        this.toolchainUtils = new ToolchainSettingsUtils(projectDescription);
        this.projectDescription = projectDescription;
        this.toolchainComponents = new HashMap<String, Set<String>>();
        this.toolchainComponents.put("COPY", new HashSet());
        this.toolchainComponents.put("LINK", new HashSet());
    }

    public void add_C_Compiler_Includes(String newEntry) {
        this.toolchainUtils.addCCompilerIncludes(newEntry);
    }

    public void add_C_Linker_Library(String newEntry) {
        this.toolchainUtils.addCOption(newEntry, "gnu.c.link.option.libs", "COND_TOOLCHAIN_LIBRARIES");
    }

    public void add_C_Linker_LibraryPath(String newEntry) {
        this.toolchainUtils.addCOption(newEntry, "gnu.c.link.option.paths", "COND_TOOLCHAIN_LIBRARIES_PATHS");
    }

    public void add_C_Compiler_Symbol(String newEntry) {
        this.toolchainUtils.addCOption(newEntry, "gnu.c.compiler.option.preprocessor.def.symbols", "COND_TOOLCHAIN_DEFINES");
    }

    public void add_C_Assembler_Symbol(String newEntry) {
        this.toolchainUtils.addCOption(newEntry, ToolchainSettingsUtils.getAssemblerSymbolOption(this.projectDescription), "COND_TOOLCHAIN_ASM_DEFINES");
    }

    public void add_C_Option(String newEntry, String cOption) {
        this.toolchainUtils.addCCustomOption(newEntry, cOption, "COND_TOOLCHAIN_CUSTOM_OPTION");
    }

    public String get_Compiler() {
        return this.toolchainUtils.getToolchain();
    }

    public String get_Compiler_Name() {
        return this.toolchainUtils.getToolchainName();
    }

    public String get_Compiler_Id() {
        return this.toolchainUtils.getToolchainId();
    }

    public boolean addAllComponents(List<String> compIds, boolean standalone, boolean importOtherFiles) {
        Set<Object> currentDependencies = new HashSet();
        currentDependencies = standalone ? this.toolchainComponents.get("COPY") : this.toolchainComponents.get("LINK");
        return currentDependencies.addAll(compIds);
    }

    public boolean addComponents(String id, boolean standalone, boolean importOtherFiles) {
        return this.addAllComponents(new ArrayList<String>(Arrays.asList(id)), standalone, importOtherFiles);
    }

    public void saveToolchainComponents() {
        StringBuilder components = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : this.toolchainComponents.entrySet()) {
            Set<String> value = entry.getValue();
            if (value.isEmpty()) continue;
            if (components.length() != 0) {
                components.append(",");
            }
            components.append(String.valueOf(entry.getKey()) + "=" + String.join((CharSequence)";", value));
        }
        ProjectPropertiesManager.addOneEntry(this.projectDescription, "COND_TOOLCHAIN_COMPONENTS_OPTION", components.toString(), STORAGE_ID);
    }
}

