/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.codemanager.ICodeProviderListener;
import com.nxp.swtools.codemanager.IToolSpecificCodeManager;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.scripting.PeripheralsScriptProfile;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.scripting.api.IScriptProfile;
import javax.script.CompiledScript;
import org.eclipse.swt.widgets.Display;

public class PeriphsSpecificCodeManager
implements IToolSpecificCodeManager {
    Controller controller;

    public PeriphsSpecificCodeManager(Controller controller) {
        this.controller = controller;
    }

    public boolean isCodeGenerationAllowed() {
        return this.controller.isTurnedOn() && this.controller.isMcuSupported() && this.controller.getProfile().getFunctionalGroups().size() <= this.controller.getMaximumNumberOfFunctionalGroups();
    }

    public @Nullable CompiledScript getCompiledScript() {
        return this.controller.getMcu().getCodeGeneratorScript();
    }

    public IScriptProfile getScriptProfile() {
        if (this.shouldUseAsyncGeneration()) {
            PeriphsProfile profile = new PeriphsProfile(this.controller.getProfile(), false);
            return new PeripheralsScriptProfile(this.controller.getMcu(), profile);
        }
        PeriphsProfile profile = this.controller.getProfile();
        return new PeripheralsScriptProfile(this.controller.getMcu(), profile);
    }

    public ScriptFileProvider getScriptFileProvider() {
        return new ScriptFileProvider(this.controller.getMcu().getScriptFileFolders());
    }

    public @Nullable Display getDisplay() {
        return this.controller.display;
    }

    public void runPostGenerationAction(IScriptProfile profile, @Nullable ScriptResult generatedCode) {
        if (generatedCode != null && !generatedCode.containsAnyError() && profile instanceof PeripheralsScriptProfile) {
            ((PeripheralsScriptProfile)profile).applyDependencies();
        }
        this.controller.updateValidationParams();
    }

    public @Nullable ICodeProviderListener getCodeProviderListener() {
        return this.controller.getCodeRefreshManagerHandler();
    }

    public boolean shouldUseAsyncGeneration() {
        String property = SWToolsProperties.getProperty((String)"com.nxp.swtools.periph.code.generation.synchronous", null);
        if (property == null) {
            return !SWToolsProperties.isHeadlessOn();
        }
        return !Boolean.parseBoolean(property);
    }
}

