/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.importer;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.model.yaml.PeripheralsYamlConverter;
import com.nxp.swtools.periphs.model.yaml.PeriphsProfileInfo;
import com.nxp.swtools.periphs.model.yaml.converters.YamlStorageConverter;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.provider.importer.IToolImporter;
import com.nxp.swtools.provider.importer.YamlNotFoundException;
import com.nxp.swtools.utils.scripting.FileYamlContent;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class PeriphsImporter
implements IToolImporter {
    @NonNull
    private static final @NonNull List<@NonNull Pattern> FILES_REGEX = SwToolsProduct.isUctProduct() ? CollectionsUtils.unmodifiableList(Arrays.asList(Pattern.compile("peripherals.*\\.c"), Pattern.compile(".*\\_cfg.c", 2))) : CollectionsUtils.unmodifiableList((List)CollectionsUtils.asList((Object)Pattern.compile("peripherals.*\\.c")));
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(PeriphsImporter.class);

    @Nullable Logger getUserLogger() {
        if (SWToolsProperties.isTestOn()) {
            return null;
        }
        Display display = Display.getCurrent();
        if (display != null && Thread.currentThread().equals(display.getThread())) {
            return UserLogger.getInstance();
        }
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        UIJob job = UIJobHelper.runUIJobSystem(() -> result.set(UserLogger.getInstance()));
        if (job == null) {
            return null;
        }
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return result.get();
    }

    public @NonNull String getToolId() {
        return "Peripherals";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable ISharedConfiguration parse(@NonNull InputStream inputStream, @NonNull StringBuffer outMessage, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IToolImporter.ParseMode mode, @Nullable IMcuIdentification targetMcuConfig, @Nullable String coreId) throws IOException, YamlNotFoundException {
        ProcessorCore selectedCore;
        PeripheralsYamlConverter converter = new PeripheralsYamlConverter();
        @NonNull @NonNull FileYamlContent parsedYaml = converter.parse(inputStream);
        if (parsedYaml == null) {
            return null;
        }
        if (SWToolsProperties.isHeadlessOn()) {
            ImportHelper.checkOrDownloadDevice((FileYamlContent)parsedYaml);
        }
        ISharedConfiguration result = parsedYaml.toConfiguration(targetMcuConfig);
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        if (IToolImporter.ParseMode.IMPORT_TO_CURRENT == mode && (selectedCore = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getSelectedCore()) != null) {
            coreId = selectedCore.getID();
        }
        if (coreId != null) {
            for (StoragePeriphsFuncGroup yamlFuncGroup : ((PeriphsProfileInfo)parsedYaml.getProfileInfo()).getFunctionalGroups()) {
                if (!yamlFuncGroup.getSelectedCore().isEmpty()) continue;
                yamlFuncGroup.setSelectedCore(coreId);
            }
        }
        result.getTools().setTool((StorageTool)YamlStorageConverter.toStorage((FileYamlContent)parsedYaml, (ISupportedDerivativesForSwTools)derivatives));
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull StoragePeriphsTool mergeStorageTools(@NonNull StorageTool storageTool1, @NonNull StorageTool storageTool2, boolean mergeFcGrStorages) {
        StoragePeriphsTool result = new StoragePeriphsTool();
        if (!(storageTool1 instanceof StoragePeriphsTool) || !(storageTool2 instanceof StoragePeriphsTool)) {
            LOGGER.log(Level.SEVERE, "[TOOL] Trying to merge peripheral storages that are not instances of \"StoragePeriphsTool\"");
            return result;
        }
        if (!storageTool1.isEnabled() && !storageTool2.isEnabled()) {
            result.setEnabled(false);
        }
        StoragePeriphsTool storagePeriphsTool1 = (StoragePeriphsTool)storageTool1;
        StoragePeriphsTool storagePeriphsTool2 = (StoragePeriphsTool)storageTool2;
        @NonNull ArrayList funcGroups1 = storagePeriphsTool1.getFuncGroups();
        @NonNull ArrayList funcGroups2 = storagePeriphsTool2.getFuncGroups();
        StoragePeriphsFuncGroup initFuncGroup = (StoragePeriphsFuncGroup)CollectionsUtils.nullableOptionalGet(funcGroups1.stream().filter(x -> x.isCalledFromInit()).findAny());
        @NonNull List resultFuncGroups = YamlStorageConverter.mergeFuncGroupsStorages((List)funcGroups1, (List)funcGroups2, (boolean)mergeFcGrStorages);
        if (initFuncGroup != null) {
            for (StoragePeriphsFuncGroup func : resultFuncGroups) {
                if (Objects.equals(func.getName(), initFuncGroup.getName())) {
                    func.setCalledFromInit(true);
                    continue;
                }
                func.setCalledFromInit(false);
            }
        }
        result.setFuncGroups(new ArrayList(resultFuncGroups));
        @NonNull ArrayList components1 = storagePeriphsTool1.getComponents();
        @NonNull ArrayList components2 = storagePeriphsTool2.getComponents();
        result.setComponents(YamlStorageConverter.mergeComponentsStorages((ArrayList)components1, (List)components2, (Logger)this.getUserLogger()));
        result.setGeneratedProjectFiles(storagePeriphsTool1.getGeneratedProjectFiles());
        return result;
    }

    public @NonNull List<@NonNull Pattern> getImportibleFilesRegexes() {
        return FILES_REGEX;
    }

    public boolean importConfigurationFromBitFieldState(@NonNull Collection<?> bitFieldInfo, @Nullable Map<@NonNull String, @NonNull String> specificSettings) {
        return false;
    }

    public boolean importConfigurationFromBitFieldState(@NonNull Collection<?> bitFieldInfo, @NonNull String functionialGroupName, @Nullable Map<@NonNull String, @NonNull String> specificSettings) {
        return false;
    }

    public @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IToolImporter.MergeOption> getSupportedMergeOptions() {
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IToolImporter.MergeOption> supportedOptions = new ArrayList<IToolImporter.MergeOption>(super.getSupportedMergeOptions());
        supportedOptions.add(IToolImporter.MergeOption.IMPORT_REPLACE_APPEND_COMPONENTS);
        if (!PeriphsImporter.canAddFcGroup()) {
            supportedOptions.remove(IToolImporter.MergeOption.IMPORT_RENAME);
        }
        return supportedOptions;
    }

    private static boolean canAddFcGroup() {
        Controller controllerInstance = Controller.getInstance();
        return controllerInstance.getProfile().getFunctionalGroups().size() < controllerInstance.getMaximumNumberOfFunctionalGroups();
    }
}

