/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.installer.core.internal;

import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.installer.core.MIPackAgregator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MIPackCategoryCompator
implements Comparator<MIPackAgregator> {
    public static final MIPackCategoryCompator CATEGORY_COMPARATOR = new MIPackCategoryCompator();

    private MIPackCategoryCompator() {
    }

    @Override
    public int compare(MIPackAgregator first, MIPackAgregator second) {
        ModularPack packFirst = first.getPack();
        ModularPack packSecond = second.getPack();
        if (packFirst == null && packSecond == null) {
            return 0;
        }
        if (packFirst == null) {
            return -1;
        }
        if (packSecond == null) {
            return 1;
        }
        if (packFirst.equals(packSecond)) {
            return 0;
        }
        ArrayList<String> categoryFirst = new ArrayList<String>(packFirst.getCategories());
        ArrayList<String> categorySecond = new ArrayList<String>(packSecond.getCategories());
        if (categoryFirst.isEmpty() && categorySecond.isEmpty()) {
            int compareToIgnoreCase = packFirst.getName().compareToIgnoreCase(packSecond.getName());
            return this.normalizeCompareAnswer(compareToIgnoreCase);
        }
        if (categoryFirst.isEmpty() && !categorySecond.isEmpty()) {
            return -1;
        }
        if (!categoryFirst.isEmpty() && categorySecond.isEmpty()) {
            return 1;
        }
        if (categoryFirst.size() > 1) {
            Collections.sort(categoryFirst, (cat1, cat2) -> this.normalizeCompareAnswer(cat1.compareToIgnoreCase((String)cat2)));
        }
        if (categorySecond.size() > 1) {
            Collections.sort(categorySecond, (cat1, cat2) -> this.normalizeCompareAnswer(cat1.compareToIgnoreCase((String)cat2)));
        }
        if (categoryFirst.size() >= categorySecond.size()) {
            return this.compareCategorySequence(categoryFirst, categorySecond);
        }
        return this.compareCategorySequence(categorySecond, categoryFirst);
    }

    private int compareCategorySequence(List<String> catrgoryFirst, List<String> categorySecond) {
        int normalizeCompareAnswer = -1;
        for (int i = 0; i < categorySecond.size(); ++i) {
            normalizeCompareAnswer = this.normalizeCompareAnswer(catrgoryFirst.get(i).compareToIgnoreCase(categorySecond.get(i)));
            if (normalizeCompareAnswer == 0) {
                continue;
            }
            return normalizeCompareAnswer;
        }
        if (normalizeCompareAnswer == 0 && catrgoryFirst.size() > categorySecond.size()) {
            return -1;
        }
        return 1;
    }

    private int normalizeCompareAnswer(int compareToIgnoreCase) {
        if (compareToIgnoreCase < 0) {
            return -1;
        }
        if (compareToIgnoreCase == 0) {
            return 0;
        }
        return 1;
    }
}

