/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.installer.core.schedulers;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DateFormate {
    private static final String UPDATE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private Preferences prefs;

    public DateFormate(Preferences prefs) {
        this.prefs = prefs;
    }

    public Date store(Date datetime) {
        this.prefs.put("lastAutoCheckForUpdates", this.dateToString(datetime));
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            Log.logError((String)e.getMessage());
        }
        return datetime;
    }

    public Date readAndStoreIfAbsent(Date toStore) {
        Date date = this.read();
        if (date == null) {
            return this.store(toStore);
        }
        return date;
    }

    public Date read() {
        String lastCheckDateString = this.prefs.get("lastAutoCheckForUpdates", null);
        if (lastCheckDateString == null || lastCheckDateString.length() == 0) {
            return null;
        }
        return this.dateFromString(lastCheckDateString);
    }

    private String dateToString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(UPDATE_DATE_FORMAT);
        return dateFormat.format(date);
    }

    private Date dateFromString(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(UPDATE_DATE_FORMAT);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            Log.logError((String)e.getMessage());
            return null;
        }
    }
}

