/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.core;

import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerGdbControl;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.GenericProgressDialogStatusHandler;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.S32DebuggerFlashProgrammerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.core.S32DebuggerFlashProgrammerLaunchSequence;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

public class S32DebuggerFlashProgrammerGdbControl
extends S32DebuggerGdbControl {
    private static final String WRONG_FORMAT_MESSAGE = "Wrong cluster status string is received from debugger; cannot parse";
    private static final String CLUSTER_MESSAGE = "Cluster %s of %s...";
    private static final String PATTERN_F_SECTORS_UPDATED = ".*F-SECTOR-UPDATED.*";
    private static final String PATTERN_F_SECTOR_TOTAL = ".*F-SECTOR-TOTAL.*";

    public S32DebuggerFlashProgrammerGdbControl(DsfSession session, ILaunchConfiguration config, CommandFactory factory) {
        super(session, config, factory);
    }

    protected Sequence getCompleteInitializationSequence(Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        this.lSequence = new S32DebuggerFlashProgrammerLaunchSequence(this.getSession(), attributes, rm);
        return this.lSequence;
    }

    protected void checkTraceLineForPatterns(String line) {
        String clusterData;
        super.checkTraceLineForPatterns(line);
        if (this.matchPattern(line, PATTERN_F_SECTOR_TOTAL)) {
            clusterData = this.getValueFromLogLine(line);
            try {
                this.passFlashingStatus(String.format(CLUSTER_MESSAGE, 0, clusterData));
            }
            catch (NullPointerException nullPointerException) {
                S32DebuggerFlashProgrammerCoreActivator.getDefault().logError(WRONG_FORMAT_MESSAGE);
            }
        }
        if (this.matchPattern(line, PATTERN_F_SECTORS_UPDATED)) {
            clusterData = this.getValueFromLogLine(line);
            try {
                String[] clusterDataValues = clusterData.split("/");
                this.passFlashingStatus(String.format(CLUSTER_MESSAGE, clusterDataValues[0], clusterDataValues[1]));
            }
            catch (NullPointerException nullPointerException) {
                S32DebuggerFlashProgrammerCoreActivator.getDefault().logError(WRONG_FORMAT_MESSAGE);
            }
        }
    }

    private String getValueFromLogLine(String line) {
        int leftBracketPos = line.indexOf(40);
        int rightBracketPos = line.indexOf(41);
        if (leftBracketPos != -1 && rightBracketPos != -1) {
            return line.substring(leftBracketPos + 1, rightBracketPos);
        }
        return null;
    }

    private void passFlashingStatus(String toPass) {
        RcpStatusHandler handler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.flashingProgressStatusHandler");
        if (handler != null && handler instanceof GenericProgressDialogStatusHandler) {
            ((GenericProgressDialogStatusHandler)handler).setSubTask(toPass);
        }
    }
}

